/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.ejb;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.identitytrust.IdentityTrustException;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.integration.ejb.SecurityActions;
import org.jboss.security.integration.ejb.SecurityHelper;

public class EJBAuthenticationHelper
extends SecurityHelper {
    public EJBAuthenticationHelper(SecurityContext sc) {
        super(sc);
    }

    public boolean isTrusted() throws IdentityTrustException {
        IdentityTrustManager.TrustDecision td = IdentityTrustManager.TrustDecision.NotApplicable;
        IdentityTrustManager itm = this.securityContext.getIdentityTrustManager();
        if (itm != null && (td = itm.isTrusted(this.securityContext)) == IdentityTrustManager.TrustDecision.Deny) {
            throw new IdentityTrustException("Caller denied by identity trust framework");
        }
        return td == IdentityTrustManager.TrustDecision.Permit;
    }

    public boolean isValid(Subject subject, String methodName) {
        Principal p = this.securityContext.getUtil().getUserPrincipal();
        Object cred = this.securityContext.getUtil().getCredential();
        Map<String, Object> cMap = this.getContextMap(p, methodName);
        boolean auth = this.securityContext.getAuthenticationManager().isValid(p, cred, subject);
        if (!auth) {
            Exception ex = SecurityActions.getContextException();
            this.audit("Error", cMap, ex);
            if (ex == null) {
                this.audit("Failure", cMap, null);
            }
        } else {
            this.audit("Success", cMap, null);
        }
        return auth;
    }

    public void pushSubjectContext(Subject subject) {
        this.securityContext.getSubjectInfo().setAuthenticatedSubject(subject);
    }
}

