/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.kernel.Kernel;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentGroup {
    private ArrayList<VFSDeployment> deployments = new ArrayList();
    protected MainDeployer mainDeployer;
    protected Kernel kernel;
    private VirtualFileFilter filter;
    private ClassLoader classLoader;

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public void setFilter(VirtualFileFilter filter) {
        this.filter = filter;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static void addDeployments(VirtualFileFilter filter, List<VirtualFile> list, VirtualFile root, boolean recurse) throws IOException {
        List components = root.getChildren();
        for (VirtualFile component : components) {
            if (filter != null && !filter.accepts(component)) continue;
            if (component.isLeaf()) {
                list.add(component);
                continue;
            }
            if (component.getName().indexOf(46) == -1 && recurse) {
                DeploymentGroup.addDeployments(filter, list, component, true);
                continue;
            }
            list.add(component);
        }
    }

    public void process() throws DeploymentException {
        this.mainDeployer.process();
        this.mainDeployer.checkComplete();
    }

    public void undeploy() throws DeploymentException {
        for (VFSDeployment ctx : this.deployments) {
            this.mainDeployer.removeDeployment((Deployment)ctx);
        }
        this.process();
    }

    public void add(VirtualFile vf) throws DeploymentException {
        VFSDeploymentFactory factory = VFSDeploymentFactory.getInstance();
        VFSDeployment deployment = factory.createVFSDeployment(vf);
        this.mainDeployer.addDeployment((Deployment)deployment);
        this.deployments.add(deployment);
    }

    public void add(URL url) throws DeploymentException {
        VirtualFile file = DeploymentGroup.getVirtualFile(url);
        this.add(file);
    }

    public static VirtualFile getVirtualFile(URL url) throws DeploymentException {
        VirtualFile file = null;
        try {
            file = VFS.getRoot((URL)url);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to get VirtualFile for url: " + url, (Throwable)e);
        }
        return file;
    }

    public void addVirtualFiles(List<VirtualFile> vfs) throws DeploymentException {
        for (VirtualFile vf : vfs) {
            this.add(vf);
        }
    }

    public void addUrls(List<URL> urls) throws DeploymentException {
        for (URL url : urls) {
            this.add(url);
        }
    }

    public void addClasspath() throws DeploymentException {
        this.addUrls(DeploymentGroup.getClassPaths());
    }

    public static List<URL> getClassPaths() throws DeploymentException {
        ArrayList<URL> list = new ArrayList<URL>();
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            File fp = new File(path);
            if (!fp.exists()) {
                throw new DeploymentException("File in java.class.path does not exist: " + fp);
            }
            try {
                list.add(fp.toURL());
            }
            catch (MalformedURLException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        return list;
    }

    public void addClasspath(String paths) throws DeploymentException {
        List<URL> urls = DeploymentGroup.getClassPaths(paths);
        this.addUrls(urls);
    }

    public static List<URL> getClassPaths(String paths) throws DeploymentException {
        ArrayList<URL> list = new ArrayList<URL>();
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        String[] split = paths.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
        }
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken().trim();
            boolean found = false;
            for (String wantedPath : split) {
                if (!path.endsWith(File.separator + wantedPath)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            File fp = new File(path);
            if (!fp.exists()) {
                throw new DeploymentException("File in java.class.path does not exists: " + fp);
            }
            try {
                list.add(fp.toURL());
            }
            catch (MalformedURLException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        return list;
    }

    public void addResource(String resource) throws DeploymentException, NullPointerException {
        URL url;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.classLoader != null) {
            loader = this.classLoader;
        }
        if ((url = loader.getResource(resource)) == null) {
            throw new NullPointerException("Resource was null: " + resource);
        }
        this.add(url);
    }

    public void addResourceBase(String baseResource) throws DeploymentException {
        URL url;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.classLoader != null) {
            loader = this.classLoader;
        }
        if ((url = loader.getResource(baseResource)) == null) {
            throw new RuntimeException("Could not find baseResource: " + baseResource);
        }
        this.addBaseResource(url, baseResource);
    }

    protected void addBaseResource(URL url, String baseResource) throws DeploymentException {
        String urlString = url.toString();
        int idx = urlString.lastIndexOf(baseResource);
        urlString = urlString.substring(0, idx);
        URL deployUrl = null;
        try {
            deployUrl = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.add(deployUrl);
    }

    public void addResourceBases(String baseResource) throws DeploymentException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.classLoader != null) {
            loader = this.classLoader;
        }
        try {
            Enumeration<URL> urls = loader.getResources(baseResource);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                this.addBaseResource(url, baseResource);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addResourceBase(Class baseResource) throws DeploymentException {
        String resource = baseResource.getName().replace('.', '/') + ".class";
        this.addResourceBase(resource);
    }

    public void addMultipleResources(String resource) throws DeploymentException, IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.classLoader != null) {
            loader = this.classLoader;
        }
        Enumeration<URL> urls = loader.getResources(resource);
        while (urls.hasMoreElements()) {
            this.add(urls.nextElement());
        }
    }

    public void addDirectoryByResource(String resource, boolean recurse) throws DeploymentException, IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.classLoader != null) {
            loader = this.classLoader;
        }
        List<VirtualFile> files = DeploymentGroup.getDeployerDirUrlsFromResource(this.filter, loader, resource, recurse);
        this.addVirtualFiles(files);
    }

    public void addFileByResource(String resource) throws DeploymentException, IOException {
        URL url;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.classLoader != null) {
            loader = this.classLoader;
        }
        if ((url = DeploymentGroup.getDirFromResource(loader, resource)) == null) {
            throw new DeploymentException("Unable to find file from resource: " + resource);
        }
        String urlStr = url.toString();
        if (urlStr.endsWith("/")) {
            urlStr = urlStr.substring(0, urlStr.length() - 1);
        }
        url = new URL(urlStr);
        this.add(url);
    }

    public void addDirectory(URL directory, boolean recurse) throws DeploymentException, IOException {
        this.addVirtualFiles(DeploymentGroup.getDeployerDirUrls(this.filter, directory, recurse));
    }

    public List<DeploymentUnit> getDeploymentUnits() {
        ArrayList<DeploymentUnit> result = new ArrayList<DeploymentUnit>();
        MainDeployerStructure structure = (MainDeployerStructure)this.mainDeployer;
        for (VFSDeployment deployment : this.deployments) {
            DeploymentUnit unit = structure.getDeploymentUnit(deployment.getName());
            if (unit == null) {
                throw new IllegalStateException("DeploymentUnit not found " + deployment.getName());
            }
            result.add(unit);
        }
        return result;
    }

    public List<VFSDeployment> getDeployments() {
        return this.deployments;
    }

    public static List<VirtualFile> getDeployerDirUrlsFromResource(VirtualFileFilter filter, ClassLoader loader, String resource, boolean recurse) throws DeploymentException, IOException {
        URL url = DeploymentGroup.getDirFromResource(loader, resource);
        if (url == null) {
            throw new DeploymentException("Unable to find deployDir from resource: " + resource);
        }
        List<VirtualFile> files = DeploymentGroup.getDeployerDirUrls(filter, url, recurse);
        return files;
    }

    public static List<VirtualFile> getDeployerDirUrls(VirtualFileFilter filter, URL url, boolean recurse) throws DeploymentException, IOException {
        VirtualFile file = null;
        try {
            file = VFS.getRoot((URL)url);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to find deployDir from url: " + url, (Throwable)e);
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        DeploymentGroup.addDeployments(filter, files, file, recurse);
        return files;
    }

    public static URL getDirFromResource(ClassLoader loader, String resource) {
        URL url;
        int idx = resource.indexOf("/.");
        String base = resource;
        String relative = null;
        if (idx != -1) {
            base = resource.substring(0, idx);
            relative = resource.substring(idx + 1);
        }
        if ((url = loader.getResource(base)) == null) {
            return null;
        }
        String urlAsString = url.toString();
        String[] paths = urlAsString.split("/");
        int last = paths.length - 2;
        if (relative != null) {
            int i;
            String[] relativePaths = relative.split("/");
            int relativeStart = 0;
            for (String relativePath : relativePaths) {
                if (relativePath.equals("..")) {
                    --last;
                    ++relativeStart;
                    continue;
                }
                if (!relativePath.equals(".")) break;
                ++relativeStart;
            }
            urlAsString = "";
            for (i = 0; i <= last; ++i) {
                urlAsString = urlAsString + paths[i] + "/";
            }
            for (i = relativeStart; i < relativePaths.length; ++i) {
                urlAsString = urlAsString + relativePaths[i] + "/";
            }
        } else {
            urlAsString = "";
            for (int i = 0; i <= last; ++i) {
                urlAsString = urlAsString + paths[i] + "/";
            }
        }
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url;
    }
}

