/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import org.jboss.aop.instrument.FieldAccessTransformer;
import org.jboss.aop.instrument.FieldJoinPointGenerator;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.util.JavassistMethodHashing;

public class GeneratedAdvisorFieldAccessTransformer
extends FieldAccessTransformer {
    private ArrayList pendingFieldWriteInfos = new ArrayList();
    private ArrayList pendingFieldReadInfos = new ArrayList();

    public GeneratedAdvisorFieldAccessTransformer(Instrumentor instrumentor) {
        super(instrumentor);
    }

    protected void doBuildFieldWrappers(CtClass clazz, CtField field, int index, boolean shouldReplaceArrayAccess, JoinpointClassification classificationGet, JoinpointClassification classificationSet) throws NotFoundException, CannotCompileException {
        this.instrumentor.setupBasics(clazz);
        boolean wrappedGet = classificationGet.equals(JoinpointClassification.WRAPPED);
        boolean wrappedSet = classificationSet.equals(JoinpointClassification.WRAPPED);
        int mod = field.getModifiers();
        this.buildWrapperPlaceHolders(clazz, field, this.isPrepared(classificationGet), this.isPrepared(classificationSet), mod);
        try {
            if (this.isPrepared(classificationGet)) {
                this.addFieldReadInfoFieldToGeneratedAdvisor(field, index);
                wrapper.prepareForWrapping((CtMember)field, 0);
            }
            if (this.isPrepared(classificationSet)) {
                this.addFieldWriteInfoFieldToGeneratedAdvisor(field, index);
                wrapper.prepareForWrapping((CtMember)field, 1);
            }
        }
        catch (Exception e) {
            throw new CannotCompileException((Throwable)e);
        }
        if (wrappedGet) {
            wrapper.wrap((CtMember)field, 0);
            if (classificationGet.equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                this.instrumentor.dynamicTransformationObserver.fieldReadDynamicalyWrapped(field);
            }
        }
        if (wrappedSet) {
            wrapper.wrap((CtMember)field, 1);
            if (classificationSet.equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                this.instrumentor.dynamicTransformationObserver.fieldWriteDynamicalyWrapped(field);
            }
        }
        this.replaceFieldAccessInternally(clazz, field, wrappedGet, wrappedSet, index);
        this.buildWrappers(clazz, field, shouldReplaceArrayAccess, wrappedGet, wrappedSet, index);
    }

    protected String addFieldReadInfoFieldToGeneratedAdvisor(CtField field, int index) throws NotFoundException, CannotCompileException {
        CtClass genadvisor = this.getGenadvisor();
        String finame = this.addFieldReadInfoFieldWithAccessors(4, genadvisor, field);
        this.addReadJoinPoint(field, finame, index);
        long wrapperHash = JavassistMethodHashing.methodHash(field.getDeclaringClass().getDeclaredMethod(GeneratedAdvisorFieldAccessTransformer.fieldRead(field.getName())));
        ((GeneratedAdvisorInstrumentor)this.instrumentor).initialiseFieldReadInfoField(finame, index, field.getName(), wrapperHash);
        return finame;
    }

    protected boolean addInfoAsWeakReference() {
        return false;
    }

    private void addReadJoinPoint(CtField field, String finame, int index) throws CannotCompileException, NotFoundException {
        CtClass joinpoint = this.createReadJoinPointClass(field, finame, index);
        CtClass genadvisor = ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
        CtField jpfield = new CtField(joinpoint, FieldJoinPointGenerator.getGeneratedJoinPointFieldName(field.getName(), true), genadvisor);
        jpfield.setModifiers(4);
        genadvisor.addField(jpfield);
    }

    private CtClass createReadJoinPointClass(CtField field, String finame, int index) throws CannotCompileException, NotFoundException {
        return FieldJoinPointGenerator.createReadJoinpointBaseClass((GeneratedAdvisorInstrumentor)this.instrumentor, field.getDeclaringClass(), field, finame, index);
    }

    protected String addFieldWriteInfoFieldToGeneratedAdvisor(CtField field, int index) throws NotFoundException, CannotCompileException {
        CtClass genadvisor = this.getGenadvisor();
        String finame = this.addFieldWriteInfoField(4, genadvisor, field);
        this.addWriteJoinPoint(field, finame, index);
        long wrapperHash = JavassistMethodHashing.methodHash(field.getDeclaringClass().getDeclaredMethod(GeneratedAdvisorFieldAccessTransformer.fieldWrite(field.getName())));
        ((GeneratedAdvisorInstrumentor)this.instrumentor).initialiseFieldWriteInfoField(finame, index, field.getName(), wrapperHash);
        return finame;
    }

    private void addWriteJoinPoint(CtField field, String finame, int index) throws CannotCompileException, NotFoundException {
        CtClass joinpoint = this.createWriteJoinPointClass(field, finame, index);
        CtClass genadvisor = ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
        CtField jpfield = new CtField(joinpoint, FieldJoinPointGenerator.getGeneratedJoinPointFieldName(field.getName(), false), genadvisor);
        jpfield.setModifiers(4);
        genadvisor.addField(jpfield);
    }

    private CtClass createWriteJoinPointClass(CtField field, String finame, int index) throws CannotCompileException, NotFoundException {
        return FieldJoinPointGenerator.createWriteJoinpointBaseClass((GeneratedAdvisorInstrumentor)this.instrumentor, field.getDeclaringClass(), field, finame, index);
    }

    protected void buildWrapperPlaceHolders(CtClass clazz, CtField field, boolean doGet, boolean doSet, int mod) throws NotFoundException, CannotCompileException {
        super.buildWrapperPlaceHolders(clazz, field, doGet, doSet, this.getStaticModifiers(field));
        CtClass genadvisor = this.getGenadvisor();
        if (doGet) {
            CtMethod rmethod = super.buildReadWrapperPlaceHolder(genadvisor, field, GeneratedAdvisorFieldAccessTransformer.advisorFieldRead(genadvisor, field.getName()), 4);
        }
        if (doSet) {
            CtMethod wmethod = super.buildWriteWrapperPlaceHolder(genadvisor, field, GeneratedAdvisorFieldAccessTransformer.advisorFieldWrite(genadvisor, field.getName()), 4);
        }
    }

    public static String advisorFieldRead(CtClass genadvisor, String fieldName) {
        return genadvisor.getSimpleName() + "$" + GeneratedAdvisorFieldAccessTransformer.fieldRead(fieldName);
    }

    public static String advisorFieldWrite(CtClass genadvisor, String fieldName) {
        return genadvisor.getSimpleName() + "$" + GeneratedAdvisorFieldAccessTransformer.fieldWrite(fieldName);
    }

    protected String getWrapperBody(CtClass clazz, CtField field, boolean get, int fieldIndex) throws NotFoundException, CannotCompileException {
        if (get) {
            return this.getMainReadWrapperBody(clazz, field, fieldIndex);
        }
        return this.getMainWriteWrapperBody(clazz, field, fieldIndex);
    }

    protected void replaceFieldAccessInternally(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) throws CannotCompileException {
        GeneratedAdvisorFieldAccessExprEditor expr = new GeneratedAdvisorFieldAccessExprEditor(clazz, field, doGet, doSet, index);
        clazz.instrument((ExprEditor)expr);
    }

    private CtClass getGenadvisor() {
        return ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
    }

    private CtClass getGenInstanceAdvisor() {
        return ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenInstanceadvisor();
    }

    private String getAdvisorReadWrapperBody(CtClass clazz, CtField field, int index) throws NotFoundException, CannotCompileException {
        boolean isStatic = Modifier.isStatic((int)field.getModifiers());
        String code = null;
        String joinpointName = FieldJoinPointGenerator.getGeneratedJoinPointFieldName(field.getName(), true);
        String infoName = GeneratedAdvisorFieldAccessTransformer.getFieldReadInfoFieldName(field.getName());
        code = isStatic ? "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "       return " + clazz.getName() + "." + field.getName() + ";" + "   }" + "   else" + "   {" + "    " + MethodExecutionTransformer.getAopReturnStr(false) + joinpointName + "." + "invokeJoinpoint" + "();" + "   }" + "}" : "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "       return ((" + clazz.getName() + ")$1)." + field.getName() + ";" + "   }" + "   else" + "   {" + "    " + MethodExecutionTransformer.getAopReturnStr(false) + joinpointName + "." + "invokeJoinpoint" + "((" + clazz.getName() + ")$1);" + "   }" + "}";
        return code;
    }

    private String getAdvisorWriteWrapperBody(CtClass clazz, CtField field, int index, boolean shouldReplaceArrayAccess) throws NotFoundException, CannotCompileException {
        boolean isStatic = Modifier.isStatic((int)field.getModifiers());
        String code = null;
        String joinpointName = FieldJoinPointGenerator.getGeneratedJoinPointFieldName(field.getName(), false);
        String infoName = GeneratedAdvisorFieldAccessTransformer.getFieldWriteInfoFieldName(field.getName());
        if (isStatic) {
            String targetString = "java.lang.Class.forName(\"" + clazz.getName() + "\")";
            String fieldString = clazz.getName() + "." + field.getName();
            code = "{    " + this.getArrayWriteRegistration(shouldReplaceArrayAccess, targetString, field, fieldString, "$2") + "   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "   " + fieldString + " = $2;" + "   }" + "   else" + "   {" + "   " + joinpointName + "." + "invokeJoinpoint" + "($2);" + "   }" + "}";
        } else {
            String targetString = "((" + clazz.getName() + ")$1)";
            String fieldString = targetString + "." + field.getName();
            code = "{    " + this.getArrayWriteRegistration(shouldReplaceArrayAccess, targetString, field, fieldString, "$2") + "   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "       " + fieldString + " = $2;" + "   }" + "   else" + "   {" + "   " + MethodExecutionTransformer.getAopReturnStr(false) + joinpointName + "." + "invokeJoinpoint" + "((" + clazz.getName() + ")$1, $2);" + "   }" + "}";
        }
        return code;
    }

    private String getMainReadWrapperBody(CtClass clazz, CtField field, int index) throws NotFoundException, CannotCompileException {
        boolean isStatic = Modifier.isStatic((int)field.getModifiers());
        String advisor = isStatic ? "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + ")" + "aop$classAdvisor$aop" + ")" : "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + ")((" + clazz.getName() + ")$1)." + "getCurrentAdvisor$aop()" + ")";
        return "return " + advisor + "." + GeneratedAdvisorFieldAccessTransformer.advisorFieldRead(this.getGenadvisor(), field.getName()) + "($$);";
    }

    private String getMainWriteWrapperBody(CtClass clazz, CtField field, int index) throws NotFoundException, CannotCompileException {
        boolean isStatic = Modifier.isStatic((int)field.getModifiers());
        String advisor = isStatic ? "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + ")" + "aop$classAdvisor$aop" + ")" : "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + ")((" + clazz.getName() + ")$1)." + "getCurrentAdvisor$aop()" + ")";
        return advisor + "." + GeneratedAdvisorFieldAccessTransformer.advisorFieldWrite(this.getGenadvisor(), field.getName()) + "($$);";
    }

    private void buildWrappers(CtClass clazz, CtField field, boolean shouldReplaceArrayAccess, boolean doGet, boolean doSet, int index) throws NotFoundException, CannotCompileException {
        CtMethod mmethod;
        String mcode;
        CtMethod method;
        String code;
        if (doGet) {
            code = this.getAdvisorReadWrapperBody(clazz, field, index);
            method = this.getGenadvisor().getDeclaredMethod(GeneratedAdvisorFieldAccessTransformer.advisorFieldRead(this.getGenadvisor(), field.getName()));
            try {
                method.setBody(code);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Field " + field + " code: " + code + " in Method " + method, e);
            }
            mcode = this.getMainReadWrapperBody(clazz, field, index);
            mmethod = clazz.getDeclaredMethod(GeneratedAdvisorFieldAccessTransformer.fieldRead(field.getName()));
            mmethod.setBody(mcode);
        }
        if (doSet) {
            code = this.getAdvisorWriteWrapperBody(clazz, field, index, shouldReplaceArrayAccess);
            method = this.getGenadvisor().getDeclaredMethod(GeneratedAdvisorFieldAccessTransformer.advisorFieldWrite(this.getGenadvisor(), field.getName()));
            try {
                method.setBody(code);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Field " + field + " code: " + code + " in Method " + method, e);
            }
            mcode = this.getMainWriteWrapperBody(clazz, field, index);
            mmethod = clazz.getDeclaredMethod(GeneratedAdvisorFieldAccessTransformer.fieldWrite(field.getName()));
            mmethod.setBody(mcode);
        }
    }

    protected class GeneratedAdvisorFieldAccessExprEditor
    extends FieldAccessTransformer.FieldAccessExprEditor {
        public GeneratedAdvisorFieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) {
            super(clazz, field, doGet, doSet, index);
        }

        protected void replaceRead(FieldAccess fieldAccess) throws CannotCompileException {
            if (fieldAccess.isStatic()) {
                String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "(null);" + "    } " + "";
                fieldAccess.replace(code);
            } else {
                String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "($0);" + "    } " + "";
                fieldAccess.replace(code);
            }
        }

        protected void replaceWrite(FieldAccess fieldAccess) throws CannotCompileException {
            String fieldWrite = FieldAccessTransformer.fieldWrite(this.field.getName());
            if (fieldAccess.isStatic()) {
                String code = "    {        " + fieldWrite + "(null, $1);" + "    } " + "";
                fieldAccess.replace(code);
            } else {
                String code = "    {        " + fieldWrite + "($0, $1);" + "    } " + "";
                fieldAccess.replace(code);
            }
        }
    }

    private class PendingFieldInfo {
        CtField field;
        int index;

        public PendingFieldInfo(CtField field, int index) {
            this.field = field;
            this.index = index;
        }

        public CtField getField() {
            return this.field;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

