/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.instrument.OptimizedInvocations;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.JavassistToReflect;
import org.jboss.aop.util.logging.AOPLogger;
import org.jboss.logging.Logger;

public abstract class OptimizedBehaviourInvocations
extends OptimizedInvocations {
    private static final Logger logger = AOPLogger.getLogger(OptimizedBehaviourInvocations.class);
    public static final String ENFORCE_ARGS_CONSISTENCY = "enforceArgsConsistency";
    protected static final String INVOKE_TARGET = "invokeTarget";
    static final String GET_ARGUMENTS = "getArguments";
    private static final String SET_ARGUMENTS = "setArguments";

    protected static String setArguments(int length) {
        return OptimizedBehaviourInvocations.setArguments("invocation", length, 0);
    }

    protected static void addArgumentFieldsAndAccessors(ClassPool pool, CtClass invocation, CtClass[] params, boolean hasMarshalledArguments) throws NotFoundException, CannotCompileException {
        OptimizedBehaviourInvocations.addArgumentFieldsToInvocation(invocation, params);
        OptimizedBehaviourInvocations.addGetArguments(pool, invocation, params, hasMarshalledArguments);
        OptimizedBehaviourInvocations.addSetArguments(pool, invocation, params);
        OptimizedBehaviourInvocations.addEnforceArgsConsistency(invocation, params);
    }

    protected static void addDispatch(CtClass invocation, String methodName, CtClass[] params, String dispatchLine, String beforeDispatch, String afterDispatch) throws NotFoundException, CannotCompileException {
        StringBuffer sb = new StringBuffer("{");
        sb.append(beforeDispatch);
        sb.append(ENFORCE_ARGS_CONSISTENCY).append("();");
        sb.append(dispatchLine);
        if (params.length == 0) {
            sb.append("();");
        } else {
            sb.append("(arg0");
            for (int i = 1; i < params.length; ++i) {
                sb.append(", ");
                sb.append("arg");
                sb.append(i);
            }
            sb.append(");");
        }
        sb.append(afterDispatch);
        sb.append("}");
        CtMethod dispatch = null;
        CtMethod in = invocation.getSuperclass().getDeclaredMethod(INVOKE_TARGET);
        try {
            dispatch = CtNewMethod.make((CtClass)in.getReturnType(), (String)methodName, (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), (String)sb.toString(), (CtClass)invocation);
        }
        catch (CannotCompileException e) {
            logger.error(sb.toString());
            throw e;
        }
        dispatch.setModifiers(in.getModifiers());
        invocation.addMethod(dispatch);
    }

    private static String setArguments(String inv, int length, int offset) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < length; ++i) {
            sb.append(inv + ".arg" + i + " = $" + (i + 1 + offset) + "; ");
        }
        return sb.toString();
    }

    private static void addSetArguments(ClassPool pool, CtClass invocation, CtClass[] params) throws NotFoundException, CannotCompileException {
        if (params.length == 0) {
            return;
        }
        CtClass methodInvocation = pool.get(MethodInvocation.class.getName());
        CtMethod template = methodInvocation.getDeclaredMethod(SET_ARGUMENTS);
        StringBuffer code = new StringBuffer("{");
        code.append("   inconsistentArgs = true;");
        code.append("   arguments = $1; ");
        code.append("}");
        CtMethod setArguments = null;
        try {
            setArguments = CtNewMethod.make((CtClass)template.getReturnType(), (String)template.getName(), (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (String)code.toString(), (CtClass)invocation);
        }
        catch (CannotCompileException e) {
            logger.error(code.toString());
            throw e;
        }
        setArguments.setModifiers(template.getModifiers());
        invocation.addMethod(setArguments);
    }

    private static void addGetArguments(ClassPool pool, CtClass invocation, CtClass[] params, boolean hasMarshalledArguments) throws CannotCompileException {
        try {
            CtClass methodInvocation = pool.get(MethodInvocation.class.getName());
            CtMethod template = methodInvocation.getDeclaredMethod(GET_ARGUMENTS);
            StringBuffer code = new StringBuffer();
            code.append("{ ");
            if (params.length != 0) {
                code.append("   inconsistentArgs = true;");
            }
            if (hasMarshalledArguments) {
                code.append("   if (super.marshalledArguments != null)");
                code.append("   {");
                code.append("      Object[] args = super.").append(GET_ARGUMENTS);
                code.append("();      ");
                code.append(SET_ARGUMENTS).append("(args);");
                code.append("      return args;");
                code.append("   }");
            }
            code.append("   if (arguments != (Object[])null) { return (Object[])arguments; } ");
            code.append("   arguments = new Object[" + params.length + "]; ");
            for (int i = 0; i < params.length; ++i) {
                code.append("   arguments[" + i + "] = ($w)arg" + i + "; ");
            }
            code.append("   return arguments; }");
            CtMethod getArguments = null;
            try {
                getArguments = CtNewMethod.make((CtClass)template.getReturnType(), (String)template.getName(), (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (String)code.toString(), (CtClass)invocation);
            }
            catch (CannotCompileException e) {
                logger.error(code.toString());
                throw e;
            }
            getArguments.setModifiers(template.getModifiers());
            invocation.addMethod(getArguments);
        }
        catch (NotFoundException e) {
            // empty catch block
        }
    }

    private static void addEnforceArgsConsistency(CtClass invocation, CtClass[] params) throws CannotCompileException {
        StringBuffer code = new StringBuffer();
        code.append("{ ");
        if (params.length != 0) {
            code.append("if(inconsistentArgs) {");
            code.append("arg0 = ");
            code.append(JavassistToReflect.castInvocationValueToTypeString(params[0], "arguments[0]"));
            for (int i = 1; i < params.length; ++i) {
                code.append("; arg").append(i).append('=');
                code.append(JavassistToReflect.castInvocationValueToTypeString(params[i], "arguments[" + i + "]"));
            }
            code.append("; }");
        }
        code.append('}');
        CtMethod enforceArgsConsistency = null;
        try {
            enforceArgsConsistency = CtNewMethod.make((CtClass)CtClass.voidType, (String)ENFORCE_ARGS_CONSISTENCY, (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)code.toString(), (CtClass)invocation);
        }
        catch (CannotCompileException e) {
            logger.error(code.toString());
            throw e;
        }
        enforceArgsConsistency.setModifiers(16);
        invocation.addMethod(enforceArgsConsistency);
    }

    private static void addArgumentFieldsToInvocation(CtClass invocation, CtClass[] params) throws CannotCompileException {
        if (params.length == 0) {
            return;
        }
        CtField inconsistentArgs = new CtField(CtClass.booleanType, "inconsistentArgs", invocation);
        invocation.addField(inconsistentArgs, CtField.Initializer.byExpr((String)"false"));
        for (int i = 0; i < params.length; ++i) {
            CtField field = new CtField(params[i], "arg" + i, invocation);
            field.setModifiers(1);
            invocation.addField(field);
        }
    }
}

