/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentContext;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSDeploymentUnit;
import org.jboss.deployers.vfs.plugins.structure.MetaDataMatchFilter;
import org.jboss.deployers.vfs.plugins.structure.SecurityActions;
import org.jboss.deployers.vfs.plugins.structure.VFSDeploymentResourceLoaderImpl;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentResourceLoader;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractVFSDeploymentContext
extends AbstractDeploymentContext
implements VFSDeploymentContext {
    private static final long serialVersionUID = 4474515937180482776L;
    private static final Logger log = Logger.getLogger(AbstractVFSDeploymentContext.class);
    private VirtualFile root;
    private List<VirtualFile> metaDataLocations;
    private List<VirtualFile> classPath;
    private transient VFSDeploymentResourceLoader loader;

    static final String safeVirtualFileName(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        try {
            return root.toURI().toString();
        }
        catch (Exception e) {
            return root.getName();
        }
    }

    public AbstractVFSDeploymentContext() {
    }

    public AbstractVFSDeploymentContext(VirtualFile root, String relativePath) {
        super(AbstractVFSDeploymentContext.safeVirtualFileName(root), root.getName(), relativePath);
        this.root = root;
    }

    @Override
    public VirtualFile getRoot() {
        return this.root;
    }

    @Override
    public void setMetaDataPath(List<String> paths) {
        if (paths == null) {
            this.setMetaDataLocations(null);
            return;
        }
        try {
            ArrayList<VirtualFile> locations = new ArrayList<VirtualFile>();
            for (String path : paths) {
                if (path == null) {
                    throw new IllegalArgumentException("Null path in paths: " + paths);
                }
                locations.add(this.root.findChild(path));
            }
            this.setMetaDataLocations(locations);
        }
        catch (IOException e) {
            log.debug("Meta data path does not exist: root=" + this.root.getPathName() + " paths=" + paths);
        }
    }

    @Override
    public List<VirtualFile> getMetaDataLocations() {
        if (this.metaDataLocations == null) {
            return Collections.emptyList();
        }
        return this.metaDataLocations;
    }

    @Override
    public void setMetaDataLocations(List<VirtualFile> locations) {
        this.metaDataLocations = locations;
    }

    @Override
    public VirtualFile getMetaDataFile(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        try {
            if (this.metaDataLocations == null || this.metaDataLocations.isEmpty()) {
                String fileName;
                if (this.root != null && SecurityActions.isLeaf(this.root) && (fileName = this.root.getName()).equals(name)) {
                    return this.root;
                }
                return null;
            }
            return this.searchMetaDataLocations(name);
        }
        catch (Exception e) {
            log.trace("Error retrieving meta data: " + name + " reason=" + e);
            return null;
        }
    }

    protected VirtualFile searchMetaDataLocations(String name) {
        VirtualFile result = null;
        for (VirtualFile location : this.getMetaDataLocations()) {
            try {
                result = location.findChild(name);
                if (result == null) continue;
                log.trace("Found " + name + " in " + location.getName());
                this.deployed();
                break;
            }
            catch (IOException ignored) {
            }
        }
        return result;
    }

    @Override
    public List<VirtualFile> getMetaDataFiles(String name, String suffix) {
        if (name == null && suffix == null) {
            throw new IllegalArgumentException("Null name and suffix");
        }
        try {
            if (this.metaDataLocations == null || this.metaDataLocations.isEmpty()) {
                if (this.root != null && SecurityActions.isLeaf(this.root)) {
                    String fileName = this.root.getName();
                    if (name != null && fileName.equals(name)) {
                        return Collections.singletonList(this.root);
                    }
                    if (suffix != null && fileName.endsWith(suffix)) {
                        return Collections.singletonList(this.root);
                    }
                }
                return Collections.emptyList();
            }
            ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
            for (VirtualFile location : this.metaDataLocations) {
                List<VirtualFile> result = location.getChildren(new MetaDataMatchFilter(name, suffix));
                if (result == null || result.isEmpty()) continue;
                log.trace("Found " + name + " in " + location.getName());
                results.addAll(result);
                this.deployed();
            }
            return results;
        }
        catch (Exception e) {
            log.debug("Error retrieving meta data: name=" + name + " suffix=" + suffix, e);
            return Collections.emptyList();
        }
    }

    @Override
    public VirtualFile getFile(String name) {
        return this.getResourceLoader().getFile(name);
    }

    @Override
    public List<VirtualFile> getClassPath() {
        return this.classPath;
    }

    @Override
    public void setClassPath(List<VirtualFile> paths) {
        this.classPath = paths;
        if (log.isTraceEnabled() && paths != null) {
            log.trace("ClassPath for " + this.root.getPathName() + " is " + VFSUtils.getPathsString(paths));
        }
    }

    @Override
    public VFSDeploymentContext getTopLevel() {
        return (VFSDeploymentContext)super.getTopLevel();
    }

    @Override
    public VFSDeploymentResourceLoader getResourceLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        this.loader = new VFSDeploymentResourceLoaderImpl(this.getRoot());
        return this.loader;
    }

    @Override
    protected DeploymentUnit createDeploymentUnit() {
        return new AbstractVFSDeploymentUnit(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.root = (VirtualFile)in.readObject();
        boolean isNullOrEmpty = in.readBoolean();
        if (!isNullOrEmpty) {
            this.metaDataLocations = (List)in.readObject();
        }
        this.classPath = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.root);
        boolean isNullOrEmpty = this.metaDataLocations == null || this.metaDataLocations.isEmpty();
        out.writeBoolean(isNullOrEmpty);
        if (!isNullOrEmpty) {
            out.writeObject(this.metaDataLocations);
        }
        out.writeObject(this.classPath);
    }
}

