/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.AnnotatedClassFilter;
import org.jboss.metadata.annotation.creator.client.ApplicationClient5MetaDataCreator;
import org.jboss.metadata.annotation.creator.ejb.EjbJar30Creator;
import org.jboss.metadata.annotation.creator.web.Web25MetaDataCreator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.metadata.client.spec.ApplicationClientMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMetaDataDeployer
extends AbstractDeployer {
    public static final String EJB_ANNOTATED_ATTACHMENT_NAME = "annotated." + EjbJarMetaData.class.getName();
    public static final String CLIENT_ANNOTATED_ATTACHMENT_NAME = "annotated." + ApplicationClientMetaData.class.getName();
    public static final String WEB_ANNOTATED_ATTACHMENT_NAME = "annotated." + WebMetaData.class.getName();
    private boolean metaDataCompleteIsDefault = true;

    public AnnotationMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addOutput(EJB_ANNOTATED_ATTACHMENT_NAME);
        this.addOutput(CLIENT_ANNOTATED_ATTACHMENT_NAME);
        this.addOutput(WEB_ANNOTATED_ATTACHMENT_NAME);
    }

    public boolean isMetaDataCompleteIsDefault() {
        return this.metaDataCompleteIsDefault;
    }

    public void setMetaDataCompleteIsDefault(boolean metaDataCompleteIsDefault) {
        this.metaDataCompleteIsDefault = metaDataCompleteIsDefault;
    }

    @Override
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.deploy(vfsDeploymentUnit);
    }

    @Override
    public void undeploy(DeploymentUnit unit) {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.undeploy(vfsDeploymentUnit);
    }

    protected void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        JBossClientMetaData jbossClientMetaData;
        JBossWebMetaData jbossWebMetaData;
        boolean isComplete = this.metaDataCompleteIsDefault;
        JBossMetaData jbossMetaData = unit.getAttachment(JBossMetaData.class);
        if (jbossMetaData != null) {
            isComplete &= jbossMetaData.isMetadataComplete();
        }
        if ((jbossWebMetaData = unit.getAttachment(JBossWebMetaData.class)) != null) {
            isComplete &= jbossWebMetaData.isMetadataComplete();
        }
        if ((jbossClientMetaData = unit.getAttachment(JBossClientMetaData.class)) != null) {
            isComplete &= jbossClientMetaData.isMetadataComplete();
        }
        if (isComplete) {
            return;
        }
        VirtualFile root = unit.getRoot();
        boolean isLeaf = true;
        try {
            isLeaf = root.isLeaf();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (isLeaf) {
            return;
        }
        ClassLoader loader = unit.getClassLoader();
        List<VirtualFile> classpath = unit.getClassPath();
        if (classpath == null) {
            return;
        }
        try {
            HashMap classpathClasses = new HashMap();
            for (VirtualFile path : classpath) {
                AnnotatedClassFilter classVisitor = new AnnotatedClassFilter(unit, loader, path);
                path.visit(classVisitor);
                Map<VirtualFile, Class<?>> classes = classVisitor.getAnnotatedClasses();
                if (classes == null || classes.size() <= 0) continue;
                this.log.info("Annotated classes: " + classes);
                classpathClasses.putAll(classes);
            }
            if (classpathClasses.size() > 0) {
                DefaultAnnotationFinder<AnnotatedElement> finder = new DefaultAnnotationFinder<AnnotatedElement>();
                if (jbossWebMetaData != null) {
                    this.processJBossWebMetaData(unit, finder, classpathClasses);
                } else if (jbossClientMetaData != null) {
                    this.processJBossClientMetaData(unit, finder, classpathClasses);
                } else {
                    this.processJBossMetaData(unit, finder, classpathClasses);
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
    }

    protected void undeploy(VFSDeploymentUnit unit) {
    }

    protected void processJBossMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Map<VirtualFile, Class<?>> classes) {
        EjbJar30Creator creator = new EjbJar30Creator(finder);
        Object annotationMetaData = creator.create((Collection)classes.values());
        if (annotationMetaData != null) {
            unit.addAttachment(EJB_ANNOTATED_ATTACHMENT_NAME, annotationMetaData, EjbJarMetaData.class);
        }
    }

    protected void processJBossWebMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Map<VirtualFile, Class<?>> classes) {
        Web25MetaDataCreator creator = new Web25MetaDataCreator(finder);
        Object annotationMetaData = creator.create((Collection)classes.values());
        if (annotationMetaData != null) {
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME, annotationMetaData, WebMetaData.class);
        }
    }

    protected void processJBossClientMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Map<VirtualFile, Class<?>> classes) {
        ApplicationClient5MetaDataCreator creator = new ApplicationClient5MetaDataCreator(finder);
        Object annotationMetaData = creator.create((Collection)classes.values());
        if (annotationMetaData != null) {
            unit.addAttachment(CLIENT_ANNOTATED_ATTACHMENT_NAME, annotationMetaData, ApplicationClientMetaData.class);
        }
    }
}

