/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.security;

import java.security.Policy;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jboss.deployment.security.JaccPolicyMBean;
import org.jboss.deployment.security.JaccPolicyUtil;
import org.jboss.deployment.security.PolicyConfigurationFacadeMBean;
import org.jboss.logging.Logger;

public class PolicyConfigurationFacade
implements PolicyConfigurationFacadeMBean {
    private static Logger log = Logger.getLogger(PolicyConfigurationFacade.class);
    private String jaccContextId;
    private PolicyConfiguration policyConfiguration;
    private JaccPolicyMBean jaccPolicyMBean;
    private Object metaData;

    public PolicyConfigurationFacade(String id, Object md) {
        if (id == null) {
            throw new IllegalArgumentException("Context ID is null");
        }
        if (md == null) {
            throw new IllegalArgumentException("Meta Data is null");
        }
        this.jaccContextId = id;
        this.metaData = md;
    }

    public void create() {
        try {
            PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            this.policyConfiguration = pcf.getPolicyConfiguration(this.jaccContextId, true);
            JaccPolicyUtil.createPermissions(this.policyConfiguration, this.metaData);
        }
        catch (ClassNotFoundException e) {
            new RuntimeException(e);
        }
        catch (PolicyContextException e) {
            new RuntimeException(e);
        }
    }

    public void destroy() {
        this.policyConfiguration = null;
    }

    public void start() {
        try {
            if (this.jaccPolicyMBean != null) {
                this.jaccPolicyMBean.link(this.policyConfiguration);
            }
            this.policyConfiguration.commit();
            Policy.getPolicy().refresh();
        }
        catch (PolicyContextException e) {
            new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.policyConfiguration.delete();
        }
        catch (PolicyContextException e) {
            new RuntimeException(e);
        }
    }

    public JaccPolicyMBean getJaccPolicyMBean() {
        return this.jaccPolicyMBean;
    }

    public void setJaccPolicyMBean(JaccPolicyMBean jaccPolicy) {
        this.jaccPolicyMBean = jaccPolicy;
    }
}

