/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldPropertyMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCMappingMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCCMPFieldMetaData {
    public static final byte CHECK_DIRTY_AFTER_GET_TRUE = 1;
    public static final byte CHECK_DIRTY_AFTER_GET_FALSE = 2;
    public static final byte CHECK_DIRTY_AFTER_GET_NOT_PRESENT = 4;
    private final JDBCEntityMetaData entity;
    private final String fieldName;
    private final Class fieldType;
    private final String columnName;
    private final int jdbcType;
    private final String sqlType;
    private final boolean readOnly;
    private final int readTimeOut;
    private final boolean primaryKeyMember;
    private final boolean notNull;
    private final boolean genIndex;
    private final Field primaryKeyField;
    private final List propertyOverrides = new ArrayList();
    private final boolean unknownPkField;
    private final boolean autoIncrement;
    private final boolean relationTableField;
    private final byte checkDirtyAfterGet;
    private final String stateFactory;

    private static byte readCheckDirtyAfterGet(Element element, byte defaultValue) throws DeploymentException {
        String dirtyAfterGetStr = MetaData.getOptionalChildContent(element, "check-dirty-after-get");
        int checkDirtyAfterGet = dirtyAfterGetStr == null ? defaultValue : (Boolean.valueOf(dirtyAfterGetStr) != false ? 1 : 2);
        return (byte)checkDirtyAfterGet;
    }

    public static byte readCheckDirtyAfterGet(Element element) throws DeploymentException {
        return JDBCCMPFieldMetaData.readCheckDirtyAfterGet(element, (byte)4);
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity) {
        this.entity = entity;
        this.fieldName = entity.getName() + "_upk";
        this.fieldType = entity.getPrimaryKeyClass();
        this.columnName = entity.getName() + "_upk";
        this.jdbcType = Integer.MIN_VALUE;
        this.sqlType = null;
        this.readOnly = entity.isReadOnly();
        this.readTimeOut = entity.getReadTimeOut();
        this.primaryKeyMember = true;
        this.notNull = true;
        this.primaryKeyField = null;
        this.genIndex = false;
        this.unknownPkField = true;
        this.autoIncrement = false;
        this.relationTableField = false;
        this.checkDirtyAfterGet = (byte)4;
        this.stateFactory = null;
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, String fieldName) throws DeploymentException {
        this.entity = entity;
        this.fieldName = fieldName;
        this.fieldType = this.loadFieldType(entity, fieldName);
        this.columnName = fieldName;
        this.jdbcType = Integer.MIN_VALUE;
        this.sqlType = null;
        this.readOnly = entity.isReadOnly();
        this.readTimeOut = entity.getReadTimeOut();
        this.genIndex = false;
        String pkFieldName = entity.getPrimaryKeyFieldName();
        if (pkFieldName != null) {
            this.primaryKeyField = null;
            if (pkFieldName.equals(fieldName)) {
                if (!entity.getPrimaryKeyClass().equals(this.fieldType)) {
                    throw new DeploymentException("primkey-field must be the same type as prim-key-class");
                }
                this.primaryKeyMember = true;
            } else {
                this.primaryKeyMember = false;
            }
        } else {
            Field[] fields = entity.getPrimaryKeyClass().getFields();
            boolean pkMember = false;
            Field pkField = null;
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.getName().equals(fieldName)) continue;
                if (!field.getType().equals(this.fieldType)) {
                    throw new DeploymentException("Field " + fieldName + " in prim-key-class must be of the same type.");
                }
                if (pkField != null) {
                    if (field.getDeclaringClass().equals(entity.getPrimaryKeyClass())) {
                        pkField = field;
                    }
                    Logger.getLogger(this.getClass().getName() + '.' + entity.getName()).warn("PK field " + fieldName + " was found more than once in class hierarchy of " + entity.getPrimaryKeyClass().getName() + ". Will use the one from " + pkField.getDeclaringClass().getName());
                } else {
                    pkField = field;
                }
                pkMember = true;
            }
            this.primaryKeyMember = pkMember;
            this.primaryKeyField = pkField;
        }
        this.notNull = this.fieldType.isPrimitive() || this.primaryKeyMember;
        this.unknownPkField = false;
        this.autoIncrement = false;
        this.relationTableField = false;
        this.checkDirtyAfterGet = (byte)4;
        this.stateFactory = null;
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, JDBCCMPFieldMetaData defaultValues) {
        this.entity = entity;
        this.fieldName = defaultValues.getFieldName();
        this.fieldType = defaultValues.getFieldType();
        this.columnName = defaultValues.getColumnName();
        this.jdbcType = defaultValues.getJDBCType();
        this.sqlType = defaultValues.getSQLType();
        this.readOnly = entity.isReadOnly();
        this.readTimeOut = entity.getReadTimeOut();
        this.primaryKeyMember = defaultValues.isPrimaryKeyMember();
        this.primaryKeyField = defaultValues.getPrimaryKeyField();
        this.notNull = defaultValues.isNotNull();
        this.unknownPkField = defaultValues.isUnknownPkField();
        this.autoIncrement = defaultValues.isAutoIncrement();
        this.genIndex = false;
        this.relationTableField = defaultValues.isRelationTableField();
        this.checkDirtyAfterGet = defaultValues.getCheckDirtyAfterGet();
        this.stateFactory = defaultValues.getStateFactory();
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, Element element, JDBCCMPFieldMetaData defaultValues) throws DeploymentException {
        this.entity = entity;
        this.unknownPkField = defaultValues.isUnknownPkField();
        String unknownFieldName = MetaData.getOptionalChildContent(element, "field-name");
        this.fieldName = this.unknownPkField && unknownFieldName != null ? unknownFieldName : defaultValues.getFieldName();
        String unknownPkClass = MetaData.getOptionalChildContent(element, "unknown-pk-class");
        if (unknownPkClass == null) {
            this.fieldType = defaultValues.getFieldType();
        } else {
            try {
                this.fieldType = entity.getClassLoader().loadClass(unknownPkClass);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load the class for  unknown primary key: " + unknownPkClass);
            }
        }
        String columnStr = MetaData.getOptionalChildContent(element, "column-name");
        this.columnName = columnStr != null ? columnStr : defaultValues.getColumnName();
        String jdbcStr = MetaData.getOptionalChildContent(element, "jdbc-type");
        if (jdbcStr != null) {
            this.jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcStr);
            this.sqlType = MetaData.getUniqueChildContent(element, "sql-type");
        } else {
            this.jdbcType = defaultValues.getJDBCType();
            this.sqlType = defaultValues.getSQLType();
        }
        String readOnlyStr = MetaData.getOptionalChildContent(element, "read-only");
        this.readOnly = readOnlyStr != null ? Boolean.valueOf(readOnlyStr).booleanValue() : defaultValues.isReadOnly();
        String readTimeOutStr = MetaData.getOptionalChildContent(element, "read-time-out");
        if (readTimeOutStr != null) {
            try {
                this.readTimeOut = Integer.parseInt(readTimeOutStr);
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Invalid number format in read-time-out '" + readTimeOutStr + "': " + e);
            }
        } else {
            this.readTimeOut = defaultValues.getReadTimeOut();
        }
        this.primaryKeyMember = defaultValues.isPrimaryKeyMember();
        this.primaryKeyField = defaultValues.getPrimaryKeyField();
        Element notNullElement = MetaData.getOptionalChild(element, "not-null");
        this.notNull = this.fieldType.isPrimitive() || this.primaryKeyMember || notNullElement != null;
        Iterator iterator = MetaData.getChildrenByTagName(element, "property");
        while (iterator.hasNext()) {
            this.propertyOverrides.add(new JDBCCMPFieldPropertyMetaData(this, (Element)iterator.next()));
        }
        this.autoIncrement = MetaData.getOptionalChild(element, "auto-increment") != null;
        this.genIndex = MetaData.getOptionalChild(element, "dbindex") != null;
        this.relationTableField = defaultValues.isRelationTableField();
        this.checkDirtyAfterGet = JDBCCMPFieldMetaData.readCheckDirtyAfterGet(element, defaultValues.getCheckDirtyAfterGet());
        String stateFactoryStr = MetaData.getOptionalChildContent(element, "state-factory");
        this.stateFactory = stateFactoryStr == null ? defaultValues.getStateFactory() : stateFactoryStr;
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, Element element, JDBCCMPFieldMetaData defaultValues, boolean primaryKeyMember, boolean notNull, boolean readOnly, int readTimeOut, boolean relationTableField) throws DeploymentException {
        this.entity = entity;
        this.fieldName = defaultValues.getFieldName();
        this.fieldType = defaultValues.getFieldType();
        String columnStr = MetaData.getOptionalChildContent(element, "column-name");
        this.columnName = columnStr != null ? columnStr : defaultValues.getColumnName();
        String jdbcStr = MetaData.getOptionalChildContent(element, "jdbc-type");
        if (jdbcStr != null) {
            this.jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcStr);
            this.sqlType = MetaData.getUniqueChildContent(element, "sql-type");
        } else {
            this.jdbcType = defaultValues.getJDBCType();
            this.sqlType = defaultValues.getSQLType();
        }
        this.readOnly = readOnly;
        this.readTimeOut = readTimeOut;
        this.primaryKeyMember = primaryKeyMember;
        this.notNull = notNull;
        this.primaryKeyField = defaultValues.getPrimaryKeyField();
        Iterator iterator = MetaData.getChildrenByTagName(element, "property");
        while (iterator.hasNext()) {
            this.propertyOverrides.add(new JDBCCMPFieldPropertyMetaData(this, (Element)iterator.next()));
        }
        this.unknownPkField = defaultValues.isUnknownPkField();
        this.autoIncrement = MetaData.getOptionalChild(element, "auto-increment") != null;
        this.genIndex = MetaData.getOptionalChild(element, "dbindex") != null;
        this.relationTableField = relationTableField;
        String dirtyAfterGetStr = MetaData.getOptionalChildContent(element, "check-dirty-after-get");
        this.checkDirtyAfterGet = dirtyAfterGetStr == null ? defaultValues.getCheckDirtyAfterGet() : (byte)(Boolean.valueOf(dirtyAfterGetStr) != false ? 1 : 2);
        String stateFactoryStr = MetaData.getOptionalChildContent(element, "state-factory");
        this.stateFactory = stateFactoryStr == null ? defaultValues.getStateFactory() : stateFactoryStr;
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, JDBCCMPFieldMetaData defaultValues, String columnName, boolean primaryKeyMember, boolean notNull, boolean readOnly, int readTimeOut, boolean relationTableField) {
        this.entity = entity;
        this.fieldName = defaultValues.getFieldName();
        this.fieldType = defaultValues.getFieldType();
        this.columnName = columnName;
        this.jdbcType = defaultValues.getJDBCType();
        this.sqlType = defaultValues.getSQLType();
        this.readOnly = readOnly;
        this.readTimeOut = readTimeOut;
        this.primaryKeyMember = primaryKeyMember;
        this.primaryKeyField = defaultValues.getPrimaryKeyField();
        this.notNull = notNull;
        Iterator i = defaultValues.propertyOverrides.iterator();
        while (i.hasNext()) {
            this.propertyOverrides.add(new JDBCCMPFieldPropertyMetaData(this, (JDBCCMPFieldPropertyMetaData)i.next()));
        }
        this.unknownPkField = defaultValues.isUnknownPkField();
        this.autoIncrement = false;
        this.genIndex = false;
        this.relationTableField = relationTableField;
        this.checkDirtyAfterGet = defaultValues.getCheckDirtyAfterGet();
        this.stateFactory = defaultValues.getStateFactory();
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, String fieldName, Class fieldType, String columnName, int jdbcType, String sqlType) throws DeploymentException {
        this.entity = entity;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.columnName = columnName;
        this.jdbcType = jdbcType;
        this.sqlType = sqlType;
        this.readOnly = false;
        this.readTimeOut = -1;
        this.primaryKeyMember = false;
        this.notNull = true;
        this.primaryKeyField = null;
        this.unknownPkField = false;
        this.autoIncrement = false;
        this.genIndex = false;
        this.relationTableField = false;
        this.checkDirtyAfterGet = (byte)4;
        this.stateFactory = null;
    }

    public JDBCEntityMetaData getEntity() {
        return this.entity;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class getFieldType() {
        return this.fieldType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getJDBCType() {
        return this.jdbcType;
    }

    public String getSQLType() {
        return this.sqlType;
    }

    public List getPropertyOverrides() {
        return Collections.unmodifiableList(this.propertyOverrides);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public boolean isPrimaryKeyMember() {
        return this.primaryKeyMember;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isIndexed() {
        return this.genIndex;
    }

    public Field getPrimaryKeyField() {
        return this.primaryKeyField;
    }

    public boolean isUnknownPkField() {
        return this.unknownPkField;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isRelationTableField() {
        return this.relationTableField;
    }

    public byte getCheckDirtyAfterGet() {
        return this.checkDirtyAfterGet;
    }

    public String getStateFactory() {
        return this.stateFactory;
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCCMPFieldMetaData) {
            JDBCCMPFieldMetaData cmpField = (JDBCCMPFieldMetaData)o;
            return this.fieldName.equals(cmpField.fieldName) && this.entity.equals(cmpField.entity);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.entity.hashCode();
        result = 37 * result + this.fieldName.hashCode();
        return result;
    }

    public String toString() {
        return "[JDBCCMPFieldMetaData : fieldName=" + this.fieldName + ", " + this.entity + "]";
    }

    private Class loadFieldType(JDBCEntityMetaData entity, String fieldName) throws DeploymentException {
        if (entity.isCMP1x()) {
            try {
                return entity.getEntityClass().getField(fieldName).getType();
            }
            catch (NoSuchFieldException e) {
                throw new DeploymentException("No field named '" + fieldName + "' found in entity class." + entity.getEntityClass().getName());
            }
        }
        String baseName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        String getName = "get" + baseName;
        String setName = "set" + baseName;
        Method[] methods = entity.getEntityClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers()) || !Modifier.isAbstract(methods[i].getModifiers())) continue;
            if (getName.equals(methods[i].getName()) && methods[i].getParameterTypes().length == 0 && !methods[i].getReturnType().equals(Void.TYPE)) {
                return methods[i].getReturnType();
            }
            if (!setName.equals(methods[i].getName()) || methods[i].getParameterTypes().length != 1 || !methods[i].getReturnType().equals(Void.TYPE)) continue;
            return methods[i].getParameterTypes()[0];
        }
        throw new DeploymentException("No abstract accessors for field named '" + fieldName + "' found in entity class " + entity.getEntityClass().getName());
    }
}

