/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import org.jboss.logging.Logger;

public class ConnectionFactoryHelper {
    private static Logger log = Logger.getLogger(ConnectionFactoryHelper.class);

    public static Connection createConnection(Object factory, String username, String password) throws JMSException {
        Connection connection;
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        log.debug("using connection factory: " + factory);
        log.debug("using username/password: " + String.valueOf(username) + "/-- not shown --");
        if (factory instanceof XAConnectionFactory) {
            XAConnectionFactory qFactory = (XAConnectionFactory)factory;
            connection = username != null ? qFactory.createXAConnection(username, password) : qFactory.createXAConnection();
            log.debug("created XAConnection: " + connection);
        } else if (factory instanceof ConnectionFactory) {
            ConnectionFactory qFactory = (ConnectionFactory)factory;
            connection = username != null ? qFactory.createConnection(username, password) : qFactory.createConnection();
            log.debug("created Connection: " + connection);
        } else {
            throw new IllegalArgumentException("factory is invalid");
        }
        return connection;
    }

    public static Connection createConnection(Object factory) throws JMSException {
        return ConnectionFactoryHelper.createConnection(factory, null, null);
    }

    public static QueueConnection createQueueConnection(Object factory, String username, String password) throws JMSException {
        QueueConnection connection;
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        log.debug("using connection factory: " + factory);
        log.debug("using username/password: " + String.valueOf(username) + "/-- not shown --");
        if (factory instanceof XAQueueConnectionFactory) {
            XAQueueConnectionFactory qFactory = (XAQueueConnectionFactory)factory;
            connection = username != null ? qFactory.createXAQueueConnection(username, password) : qFactory.createXAQueueConnection();
            log.debug("created XAQueueConnection: " + connection);
        } else if (factory instanceof QueueConnectionFactory) {
            QueueConnectionFactory qFactory = (QueueConnectionFactory)factory;
            connection = username != null ? qFactory.createQueueConnection(username, password) : qFactory.createQueueConnection();
            log.debug("created QueueConnection: " + connection);
        } else {
            throw new IllegalArgumentException("factory is invalid");
        }
        return connection;
    }

    public static QueueConnection createQueueConnection(Object factory) throws JMSException {
        return ConnectionFactoryHelper.createQueueConnection(factory, null, null);
    }

    public static TopicConnection createTopicConnection(Object factory, String username, String password) throws JMSException {
        TopicConnection connection;
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        log.debug("using connection factory: " + factory);
        log.debug("using username/password: " + String.valueOf(username) + "/-- not shown --");
        if (factory instanceof XATopicConnectionFactory) {
            XATopicConnectionFactory tFactory = (XATopicConnectionFactory)factory;
            connection = username != null ? tFactory.createXATopicConnection(username, password) : tFactory.createXATopicConnection();
            log.debug("created XATopicConnection: " + connection);
        } else if (factory instanceof TopicConnectionFactory) {
            TopicConnectionFactory tFactory = (TopicConnectionFactory)factory;
            connection = username != null ? tFactory.createTopicConnection(username, password) : tFactory.createTopicConnection();
            log.debug("created TopicConnection: " + connection);
        } else {
            throw new IllegalArgumentException("factory is invalid");
        }
        return connection;
    }

    public static TopicConnection createTopicConnection(Object factory) throws JMSException {
        return ConnectionFactoryHelper.createTopicConnection(factory, null, null);
    }
}

