/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dispatch;

import java.util.List;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeDispatchHelper {
    private static final Logger log = Logger.getLogger(InvokeDispatchHelper.class);

    public static Object invoke(KernelConfigurator configurator, Object target, InvokeDispatchContext context, String methodName, List<ParameterMetaData> params) throws Throwable {
        Object[] parameters;
        String[] signature;
        if (params == null || params.isEmpty()) {
            signature = new String[]{};
            parameters = new Object[]{};
        } else {
            int size = params.size();
            signature = Configurator.getParameterTypes(log.isTraceEnabled(), params);
            if (target != null) {
                MethodInfo methodInfo = Configurator.findMethodInfo(configurator.getClassInfo(target.getClass()), methodName, signature);
                parameters = Configurator.getParameters(log.isTraceEnabled(), context.getClassLoader(), methodInfo.getParameterTypes(), params);
                for (int i = 0; i < size; ++i) {
                    if (signature[i] != null) continue;
                    signature[i] = methodInfo.getParameterTypes()[i].getName();
                }
            } else {
                parameters = new Object[size];
                ClassLoader classLoader = context.getClassLoader();
                for (int i = 0; i < size; ++i) {
                    ParameterMetaData pmd = params.get(i);
                    ClassInfo typeInfo = null;
                    if (signature[i] != null) {
                        typeInfo = configurator.getClassInfo(signature[i], classLoader);
                    }
                    parameters[i] = pmd.getValue().getValue(typeInfo, classLoader);
                }
            }
        }
        return context.invoke(methodName, parameters, signature);
    }
}

