/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.validation.validator.ejb.jboss;

import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.validation.ValidationException;
import org.jboss.metadata.validation.validator.ejb.JBossEjb3SessionBeanValidatorBase;

public class CompleteEjb2xViewValidator
extends JBossEjb3SessionBeanValidatorBase {
    private static final Logger log = Logger.getLogger(CompleteEjb2xViewValidator.class);
    public static CompleteEjb2xViewValidator INSTANCE = new CompleteEjb2xViewValidator();

    protected void validate(JBossSessionBeanMetaData smd) throws ValidationException {
        String errorCode = "JBMETA-130";
        String errorMessageSuffix = "; Incomplete EJB2.x View [" + errorCode + "]";
        String remote = smd.getRemote();
        String home = smd.getHome();
        String local = smd.getLocal();
        String localHome = smd.getLocalHome();
        if (remote != null && remote.trim().length() > 0 && (home == null || home.trim().length() == 0)) {
            throw new ValidationException("EJB " + smd.getName() + " has defined EJB2.x remote component interface of " + remote + " but has no home; " + errorMessageSuffix);
        }
        if (home != null && home.trim().length() > 0 && (remote == null || remote.trim().length() == 0)) {
            throw new ValidationException("EJB " + smd.getName() + " has defined EJB2.x home interface of " + home + " but has no remote component interface; " + errorMessageSuffix);
        }
        if (local != null && local.trim().length() > 0 && (localHome == null || localHome.trim().length() == 0)) {
            throw new ValidationException("EJB " + smd.getName() + " has defined EJB2.x local component interface of " + local + " but has no localHome; " + errorMessageSuffix);
        }
        if (localHome != null && localHome.trim().length() > 0 && (local == null || local.trim().length() == 0)) {
            throw new ValidationException("EJB " + smd.getName() + " has defined EJB2.x local home interface of " + localHome + " but has no local component interface; " + errorMessageSuffix);
        }
        log.trace("Passed validation for " + errorCode);
    }
}

