/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.spi.LinkInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSUtils {
    private static final Logger log = Logger.getLogger(VFSUtils.class);
    public static final String VFS_LINK_PREFIX = ".vfslink";
    public static final String VFS_LINK_NAME = "vfs.link.name";
    public static final String VFS_LINK_TARGET = "vfs.link.target";

    public static String getPathsString(Collection<VirtualFile> paths) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (VirtualFile path : paths) {
            if (path == null) {
                throw new IllegalArgumentException("Null path in " + paths);
            }
            if (!first) {
                buffer.append(':');
            } else {
                first = false;
            }
            buffer.append(path.getPathName());
        }
        if (first) {
            buffer.append("<empty>");
        }
        return buffer.toString();
    }

    public static void addManifestLocations(VirtualFile file, List<VirtualFile> paths) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        if (paths == null) {
            throw new IllegalArgumentException("Null paths");
        }
        Manifest manifest = VFSUtils.getManifest(file);
        if (manifest == null) {
            return;
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        if (classPath == null) {
            if (log.isTraceEnabled()) {
                log.trace("Manifest has no Class-Path for " + file.getPathName());
            }
            return;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            throw new IllegalStateException(file + " has no parent.");
        }
        URL parentURL = null;
        URL vfsRootURL = null;
        int rootPathLength = 0;
        try {
            parentURL = parent.toURL();
            vfsRootURL = file.getVFS().getRoot().toURL();
            rootPathLength = vfsRootURL.getPath().length();
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException("Failed to get parent URL");
            ioe.initCause(e);
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                URL libURL = new URL(parentURL, path);
                String libPath = libURL.getPath();
                if (rootPathLength > libPath.length()) {
                    throw new IOException("Invalid rootPath: " + vfsRootURL + ", libPath: " + libPath);
                }
                String vfsLibPath = libPath.substring(rootPathLength);
                VirtualFile vf = file.getVFS().findChild(vfsLibPath);
                paths.add(vf);
            }
            catch (IOException e) {
                log.debug("Manifest Class-Path entry " + path + " ignored for " + file.getPathName() + " reason=" + e);
            }
        }
    }

    public static Manifest getManifest(VirtualFile archive) throws IOException {
        VirtualFile manifest;
        if (archive == null) {
            throw new IllegalArgumentException("Null archive");
        }
        try {
            manifest = archive.findChild("META-INF/MANIFEST.MF");
        }
        catch (IOException ignored) {
            log.debug("Can't find manifest for " + archive.getPathName());
            return null;
        }
        return VFSUtils.readManifest(manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest readManifest(VirtualFile manifest) throws IOException {
        InputStream stream = manifest.openStream();
        try {
            Manifest manifest2 = new Manifest(stream);
            return manifest2;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Manifest getManifest(VFS archive) throws IOException {
        VirtualFile root = archive.getRoot();
        return VFSUtils.getManifest(root);
    }

    public static String fixName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        int length = name.length();
        if (length <= 1) {
            return name;
        }
        if (name.charAt(length - 1) == '/') {
            return name.substring(0, length - 1);
        }
        return name;
    }

    public static String getName(URI uri) {
        int lastSlash;
        String name = uri.getPath();
        if (name != null && (lastSlash = name.lastIndexOf(47)) > 0) {
            name = name.substring(lastSlash + 1);
        }
        return name;
    }

    public static Map<String, String> parseURLQuery(String query) {
        HashMap<String, String> pairsMap = new HashMap<String, String>();
        if (query != null) {
            StringTokenizer tokenizer = new StringTokenizer(query, "=&");
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                String value = tokenizer.nextToken();
                pairsMap.put(name, value);
            }
        }
        return pairsMap;
    }

    public static boolean isLink(String name) {
        return name.indexOf(VFS_LINK_PREFIX) >= 0;
    }

    public static List<LinkInfo> readLinkInfo(InputStream is, String name, Properties props) throws IOException, URISyntaxException {
        ArrayList<LinkInfo> info = new ArrayList<LinkInfo>();
        if (!name.endsWith(".properties")) {
            throw new UnsupportedEncodingException("Unknown link format: " + name);
        }
        VFSUtils.parseLinkProperties(is, info, props);
        return info;
    }

    public static void parseLinkProperties(InputStream is, List<LinkInfo> info, Properties props) throws IOException, URISyntaxException {
        props.load(is);
        int n = 0;
        while (true) {
            String nameKey = "vfs.link.name." + n;
            String name = props.getProperty(nameKey);
            String uriKey = "vfs.link.target." + n;
            String uri = props.getProperty(uriKey);
            if (uri == null) break;
            uri = StringPropertyReplacer.replaceProperties(uri);
            LinkInfo link = new LinkInfo(name, new URI(uri));
            info.add(link);
            ++n;
        }
    }

    public static URI toURI(URL url) throws URISyntaxException {
        String urispec = url.toExternalForm();
        urispec = urispec.replaceAll(" ", "%20");
        return new URI(urispec);
    }
}

