/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public abstract class ServiceObjectFactory
implements ObjectFactory {
    private static final Logger log = Logger.getLogger(ServiceObjectFactory.class);

    protected void narrowPortSelection(UnifiedServiceRefMetaData serviceRef, ServiceMetaData serviceMetaData) {
        if (serviceMetaData.getEndpoints().size() > 1) {
            HashMap<String, UnifiedPortComponentRefMetaData> pcrefs = new HashMap<String, UnifiedPortComponentRefMetaData>();
            for (UnifiedPortComponentRefMetaData pcref : serviceRef.getPortComponentRefs()) {
                String seiName = pcref.getServiceEndpointInterface();
                if (pcrefs.get(seiName) != null) {
                    throw new WSException("Within a <service-ref> it's not allowed to use a SEI across different <port-component-ref>'s: " + seiName);
                }
                pcrefs.put(seiName, pcref);
            }
            for (String sei : pcrefs.keySet()) {
                ArrayList<QName> narrowedEndpoints = new ArrayList<QName>();
                UnifiedPortComponentRefMetaData pcref = (UnifiedPortComponentRefMetaData)pcrefs.get(sei);
                if (pcref.getServiceEndpointInterface() != null && pcref.getPortQName() != null) {
                    ArrayList<QName> pcRef2EndpointMapping = new ArrayList<QName>();
                    for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                        if (!pcref.getServiceEndpointInterface().equals(epMetaData.getServiceEndpointInterfaceName())) continue;
                        pcRef2EndpointMapping.add(epMetaData.getPortName());
                    }
                    for (QName q : pcRef2EndpointMapping) {
                        EndpointMetaData mappedEndpoint = serviceMetaData.getEndpoint(q);
                        if (pcref.getPortQName().equals(mappedEndpoint.getPortName())) continue;
                        narrowedEndpoints.add(q);
                    }
                    if (pcRef2EndpointMapping.size() > 0 && pcRef2EndpointMapping.size() == narrowedEndpoints.size()) {
                        throw new WSException("Failed to narrow available endpoints by <port-component-ref> declaration");
                    }
                    for (QName q : narrowedEndpoints) {
                        EndpointMetaData removed = serviceMetaData.removeEndpoint(q);
                        log.debug("Narrowed endpoint " + q + "(" + removed + ")");
                    }
                    continue;
                }
                log.warn("Unable to narrow port selection for " + pcref);
            }
        }
    }
}

