/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.recovery.ActionStatusService;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector;
import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TransactionStatusConnectionManager {
    private static String _typeName = TransactionStatusManagerItem.typeName();
    private Hashtable _tscTable = new Hashtable();
    private static ObjectStore _objStore = null;

    public TransactionStatusConnectionManager() {
        if (_objStore == null) {
            _objStore = TxControl.getStore();
        }
        this.updateTSMI();
    }

    public int getTransactionStatus(Uid tranUid) {
        String transactionType = "";
        int status = this.getTransactionStatus(transactionType, tranUid);
        return status;
    }

    public int getTransactionStatus(String transactionType, Uid tranUid) {
        int status;
        block7: {
            status = 9;
            String process_id = this.get_process_id(tranUid);
            if (!this._tscTable.containsKey(process_id)) {
                this.updateTSMI();
            }
            if (this._tscTable.containsKey(process_id)) {
                TransactionStatusConnector tsc = (TransactionStatusConnector)this._tscTable.get(process_id);
                if (tsc.isDead()) {
                    this._tscTable.remove(process_id);
                    tsc.delete();
                    tsc = null;
                } else {
                    status = tsc.getTransactionStatus(transactionType, tranUid);
                }
            }
            if (status == 9) {
                ActionStatusService ass = new ActionStatusService();
                try {
                    status = ass.getTransactionStatus(transactionType, tranUid.stringForm());
                }
                catch (Exception ex) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block7;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager_1", ex);
                }
            }
        }
        return status;
    }

    public void updateTSMI() {
        Vector<Uid> tsmiVector;
        InputObjectState uids;
        boolean tsmis;
        block11: {
            tsmis = false;
            uids = new InputObjectState();
            tsmiVector = new Vector<Uid>();
            try {
                tsmis = _objStore.allObjUids(_typeName, uids);
            }
            catch (ObjectStoreException ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block11;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager_2", new Object[]{ex});
            }
        }
        if (tsmis) {
            Uid theUid = new Uid(Uid.nullUid());
            boolean moreUids = true;
            while (moreUids) {
                try {
                    theUid.unpack(uids);
                    if (theUid.equals(Uid.nullUid())) {
                        moreUids = false;
                        continue;
                    }
                    Uid newUid = new Uid(theUid);
                    if (tsLogger.arjLoggerI18N.debugAllowed()) {
                        tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager_3", new Object[]{newUid});
                    }
                    tsmiVector.addElement(newUid);
                }
                catch (Exception ex) {
                    moreUids = false;
                }
            }
        }
        Enumeration tsmiEnum = tsmiVector.elements();
        while (tsmiEnum.hasMoreElements()) {
            Uid currentUid = (Uid)tsmiEnum.nextElement();
            String process_id = this.get_process_id(currentUid);
            if (this._tscTable.containsKey(process_id)) continue;
            TransactionStatusConnector tsc = new TransactionStatusConnector(process_id, currentUid);
            if (tsc.isDead()) {
                tsc.delete();
                tsc = null;
            } else {
                this._tscTable.put(process_id, tsc);
            }
            if (!tsLogger.arjLoggerI18N.debugAllowed()) continue;
            tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager_4", new Object[]{process_id});
        }
    }

    private String get_process_id(Uid uid) {
        String strUid = uid.toString();
        StringTokenizer st = new StringTokenizer(strUid, ":");
        st.nextToken();
        String process_id_in_Hex = st.nextToken();
        return process_id_in_Hex;
    }
}

