/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation.assignability;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArgumentContextualizer {
    private Type[] arguments;
    private LinkedList<VariableReplacer> variableReplacements;
    boolean initialized = false;
    private ListIterator<VariableReplacer> iterator;
    private static ReplacementScheduler<ArgumentContextualizer> replacementCreator = new ReplacementScheduler<ArgumentContextualizer>(){

        @Override
        public void scheduleReplacement(Type[] replacementTarget, int targetIndex, int variableIndex, ArgumentContextualizer outer) {
            outer.initialize();
            outer.createVariableReplacement(outer.arguments, targetIndex, variableIndex);
        }
    };
    private static ReplacementScheduler<VariableReplacer> updater = new ReplacementScheduler<VariableReplacer>(){

        @Override
        public void scheduleReplacement(Type[] replacementTarget, int targetIndex, int variableIndex, VariableReplacer replacer) {
            if (replacer.pendingExecution) {
                replacer.getContextualizer().createVariableReplacement(replacementTarget, targetIndex, variableIndex);
            } else {
                replacer.valueIndex = variableIndex;
                VariableReplacer.access$702(replacer, replacementTarget);
                replacer.argumentIndex = targetIndex;
                replacer.pendingExecution = true;
            }
        }
    };

    public static final Type[] getContextualizedArguments(ParameterizedType paramType, Class rawType, Class desiredType) {
        ArgumentContextualizer contextualizedArguments = ArgumentContextualizer.getContextualizedArgumentsInternal(desiredType, rawType);
        if (contextualizedArguments == null) {
            return null;
        }
        if (paramType != null) {
            contextualizedArguments.contextualizeVariables(null, paramType);
        }
        return contextualizedArguments.getArguments();
    }

    private static final ArgumentContextualizer getContextualizedArgumentsInternal(Class<?> desiredType, Class<?> classType) {
        Type superType = null;
        if (desiredType.isInterface()) {
            for (Type superInterface : classType.getGenericInterfaces()) {
                if ((!(superInterface instanceof Class) || !desiredType.isAssignableFrom((Class)superInterface)) && (!(superInterface instanceof ParameterizedType) || !desiredType.isAssignableFrom((Class)((ParameterizedType)superInterface).getRawType()))) continue;
                superType = superInterface;
                break;
            }
        }
        if (superType == null) {
            superType = classType.getGenericSuperclass();
        }
        ArgumentContextualizer result = null;
        if (superType instanceof Class) {
            if (superType == desiredType) {
                return null;
            }
            result = ArgumentContextualizer.getContextualizedArgumentsInternal(desiredType, (Class)superType);
        } else {
            ParameterizedType superParamType = (ParameterizedType)superType;
            Class superClassType = (Class)superParamType.getRawType();
            if (superClassType == desiredType) {
                return new ArgumentContextualizer(superParamType.getActualTypeArguments(), classType);
            }
            result = ArgumentContextualizer.getContextualizedArgumentsInternal(desiredType, superClassType);
        }
        if (result == null || !result.contextualizeVariables(classType, superType)) {
            return null;
        }
        return result;
    }

    private ArgumentContextualizer(Type[] arguments, Class<?> declaringClass) {
        this.arguments = arguments;
        for (int i = 0; i < arguments.length; ++i) {
            Type newArgument = ArgumentContextualizer.processArgument(arguments, i, declaringClass, replacementCreator, this);
            if (newArgument == null) continue;
            this.arguments[i] = newArgument;
        }
    }

    private boolean contextualizeVariables(Class subClass, Type superType) {
        if (!this.initialized || this.variableReplacements.isEmpty()) {
            this.initialized = false;
            return true;
        }
        if (superType instanceof Class) {
            return false;
        }
        ParameterizedType superParamType = (ParameterizedType)superType;
        this.iterator = this.variableReplacements.listIterator();
        while (this.iterator.hasNext()) {
            if (!this.iterator.next().replace(superParamType, subClass)) continue;
            this.iterator.remove();
        }
        this.iterator = null;
        return true;
    }

    private static <O> Type processArgument(Type[] argumentContainer, int argumentIndex, Class<?> declaringClass, ReplacementScheduler<O> recorder, O outer) {
        Type argument = argumentContainer[argumentIndex];
        if (argument instanceof Class) {
            return null;
        }
        if (argument instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)argument;
            ParameterizedType_ newParamType = null;
            Type[] arguments = paramType.getActualTypeArguments();
            for (int i = 0; i < arguments.length; ++i) {
                Type newType = ArgumentContextualizer.processArgument(arguments, i, declaringClass, recorder, outer);
                if (newType == null) continue;
                if (newParamType == null) {
                    newParamType = new ParameterizedType_(paramType);
                }
                newParamType.getActualTypeArguments()[i] = newType;
            }
            return newParamType;
        }
        if (declaringClass == null) {
            return null;
        }
        String paramName = ((TypeVariable)argument).getName();
        int index = 0;
        TypeVariable<Class<?>>[] typeVariables = declaringClass.getTypeParameters();
        for (index = 0; index < typeVariables.length && !typeVariables[index].getName().equals(paramName); ++index) {
        }
        recorder.scheduleReplacement(argumentContainer, argumentIndex, index, outer);
        return argument;
    }

    private void initialize() {
        if (!this.initialized) {
            Type[] oldResult = this.arguments;
            this.arguments = new Type[oldResult.length];
            System.arraycopy(oldResult, 0, this.arguments, 0, this.arguments.length);
            this.variableReplacements = new LinkedList();
            this.initialized = true;
        }
    }

    public Type[] getArguments() {
        return this.arguments;
    }

    private void createVariableReplacement(Type[] argumentContainer, int argumentIndex, int variableIndex) {
        if (this.iterator != null) {
            this.iterator.add(new VariableReplacer(argumentContainer, argumentIndex, variableIndex));
        } else {
            this.variableReplacements.add(new VariableReplacer(argumentContainer, argumentIndex, variableIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ReplacementScheduler<C> {
        public void scheduleReplacement(Type[] var1, int var2, int var3, C var4);
    }

    private static final class ParameterizedType_
    implements ParameterizedType {
        private Type[] arguments;
        private Type ownerType;
        private Type rawType;

        ParameterizedType_(ParameterizedType type) {
            Type[] actualArguments = type.getActualTypeArguments();
            this.arguments = new Type[actualArguments.length];
            System.arraycopy(actualArguments, 0, this.arguments, 0, actualArguments.length);
            this.ownerType = type.getOwnerType();
            this.rawType = type.getRawType();
        }

        public Type[] getActualTypeArguments() {
            return this.arguments;
        }

        public Type getOwnerType() {
            return this.ownerType;
        }

        public Type getRawType() {
            return this.rawType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType other = (ParameterizedType)obj;
            if (!this.ownerType.equals(other.getOwnerType()) || !this.rawType.equals(other.getRawType())) {
                return false;
            }
            Type[] otherArguments = other.getActualTypeArguments();
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].equals(otherArguments[i])) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VariableReplacer {
        private Type[] arguments;
        private int argumentIndex;
        private int valueIndex;
        private boolean pendingExecution;

        public VariableReplacer(Type[] arguments, int argumentIndex, int valueIndex) {
            this.valueIndex = valueIndex;
            this.arguments = arguments;
            this.argumentIndex = argumentIndex;
            this.pendingExecution = true;
        }

        public boolean replace(ParameterizedType paramType, Class<?> declaringClass) {
            this.arguments[this.argumentIndex] = paramType.getActualTypeArguments()[this.valueIndex];
            this.pendingExecution = false;
            Type newType = ArgumentContextualizer.processArgument(this.arguments, this.argumentIndex, declaringClass, updater, this);
            if (newType != null) {
                this.arguments[this.argumentIndex] = newType;
                return false;
            }
            return true;
        }

        ArgumentContextualizer getContextualizer() {
            return ArgumentContextualizer.this;
        }

        static /* synthetic */ Type[] access$702(VariableReplacer x0, Type[] x1) {
            x0.arguments = x1;
            return x1;
        }
    }
}

