/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseDelegateLoader;
import org.jboss.classloader.spi.base.ClassLoadingTask;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderManager {
    private static Logger log = Logger.getLogger("org.jboss.detailed.classloader.ClassLoaderManager");
    private static Map<BaseClassLoader, Thread> loadClassThreads = new HashMap<BaseClassLoader, Thread>();
    private static Map<Thread, List<ClassLoadingTask.ThreadTask>> loadTasksByThread = Collections.synchronizedMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerLoaderThread(BaseClassLoader classloader, Thread thread) {
        boolean trace = log.isTraceEnabled();
        Map<BaseClassLoader, Thread> map = loadClassThreads;
        synchronized (map) {
            Thread previousThread = loadClassThreads.put(classloader, thread);
            if (trace) {
                log.trace("registerLoaderThread, classloader=" + classloader + " thread=" + thread + " previousThread=" + previousThread);
            }
            Map<Thread, List<ClassLoadingTask.ThreadTask>> map2 = loadTasksByThread;
            synchronized (map2) {
                List<ClassLoadingTask.ThreadTask> taskList = loadTasksByThread.get(thread);
                if (taskList == null) {
                    taskList = Collections.synchronizedList(new LinkedList());
                    loadTasksByThread.put(thread, taskList);
                    if (trace) {
                        log.trace("Created new task list for " + thread);
                    }
                }
            }
            loadClassThreads.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLoaderThread(BaseClassLoader classLoader, Thread thread) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("unregisterLoaderThread, classloader=" + classLoader + " thread=" + thread);
        }
        Map<BaseClassLoader, Thread> map = loadClassThreads;
        synchronized (map) {
            loadClassThreads.remove(classLoader);
            loadClassThreads.notifyAll();
        }
        List<ClassLoadingTask.ThreadTask> taskList = loadTasksByThread.get(thread);
        if (taskList != null) {
            List<ClassLoadingTask.ThreadTask> list2 = taskList;
            synchronized (list2) {
                while (!taskList.isEmpty()) {
                    List<ClassLoadingTask.ThreadTask> toTaskList;
                    ClassLoadingTask.ThreadTask threadTask = taskList.remove(0);
                    ClassLoadingTask loadTask = threadTask.getLoadTask();
                    Thread requestingThread = loadTask.getRequestingThread();
                    if (trace) {
                        log.trace("Reassigning task: " + threadTask + " to " + requestingThread);
                    }
                    threadTask.setThread(null);
                    List<ClassLoadingTask.ThreadTask> list3 = toTaskList = loadTasksByThread.get(requestingThread);
                    synchronized (list3) {
                        toTaskList.add(0, threadTask);
                        loadTask.nextEvent();
                        toTaskList.notify();
                    }
                }
            }
        }
    }

    static Class<?> process(Thread thread, ClassLoadingTask task) throws ClassNotFoundException {
        Class<?> loadedClass;
        while (task.getThreadTaskCount() != 0) {
            try {
                ClassLoaderManager.nextTask(thread, task);
            }
            catch (InterruptedException e) {
                task.setLoadError(e);
                break;
            }
        }
        if ((loadedClass = task.getLoadedClass()) == null) {
            Throwable loadException = task.getLoadException();
            if (loadException instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)loadException;
            }
            if (loadException instanceof NoClassDefFoundError) {
                throw (NoClassDefFoundError)loadException;
            }
            if (loadException != null) {
                log.warn("Unexpected error during load of:" + task.getClassName(), loadException);
                String msg = "Unexpected error during load of: " + task.getClassName() + ", msg=" + loadException.getMessage();
                throw new ClassNotFoundException(msg, loadException);
            }
            throw new ClassNotFoundException("Failed to load class " + task.getClassName());
        }
        return loadedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void nextTask(Thread thread, ClassLoadingTask task) throws InterruptedException {
        ClassLoadingTask loadTask;
        List<ClassLoadingTask.ThreadTask> taskList;
        boolean trace;
        block33: {
            trace = log.isTraceEnabled();
            if (trace) {
                log.trace("Next task thread=" + thread + " task=" + task);
            }
            List<ClassLoadingTask.ThreadTask> list2 = taskList = loadTasksByThread.get(thread);
            synchronized (list2) {
                while (taskList.isEmpty() && task.getThreadTaskCount() != 0) {
                    if (trace) {
                        log.trace("Begin nextTask(WAIT_ON_EVENT), task=" + task);
                    }
                    try {
                        task.waitOnEvent();
                        taskList.wait();
                    }
                    catch (InterruptedException e) {
                        if (trace) {
                            log.trace("nextTask(WAIT_ON_EVENT), interrupted, task=" + task, e);
                        }
                        throw e;
                    }
                    if (!trace) continue;
                    log.trace("nextTask(WAIT_ON_EVENT), notified, task=" + task);
                }
                if (trace) {
                    log.trace("Continue nextTask(" + taskList.size() + "), task=" + task);
                }
                if (task.getThreadTaskCount() == 0) {
                    task.finish();
                    log.trace("End nextTask(FINISHED), task=" + task);
                    return;
                }
            }
            ClassLoadingTask.ThreadTask threadTask = taskList.remove(0);
            loadTask = threadTask.getLoadTask();
            if (trace) {
                log.trace("Begin nextTask(" + taskList.size() + "), loadTask=" + loadTask);
            }
            try {
                Thread taskThread = threadTask.getThread();
                if (taskThread == null) {
                    if (trace) {
                        log.trace("Rescheduling threadTask=" + threadTask);
                    }
                    ClassLoaderManager.scheduleTask(loadTask, threadTask.getLoader(), true);
                } else {
                    if (trace) {
                        log.trace("Running threadTask=" + threadTask);
                    }
                    threadTask.run();
                }
            }
            catch (Throwable e) {
                boolean retry;
                if (trace) {
                    log.trace("Run failed with exception", e);
                }
                boolean bl = retry = e instanceof ClassCircularityError || e.getClass().equals(LinkageError.class);
                if (retry) {
                    try {
                        ClassLoaderManager.scheduleTask(loadTask, threadTask.getLoader(), true);
                    }
                    catch (Throwable ex) {
                        loadTask.setLoadError(ex);
                        log.warn("Failed to reschedule task after CCE", ex);
                    }
                    if (trace) {
                        log.trace("Post CCE state, loadTask=" + loadTask);
                    }
                    break block33;
                }
                loadTask.setLoadError(e);
            }
            finally {
                if (threadTask.isReleaseInNextTask()) {
                    threadTask.getClassLoader().unlock();
                }
            }
        }
        if (loadTask.getThreadTaskCount() == 0) {
            List<ClassLoadingTask.ThreadTask> loadTaskThreadTasks;
            List<ClassLoadingTask.ThreadTask> list3 = loadTaskThreadTasks = loadTasksByThread.get(loadTask.getRequestingThread());
            synchronized (list3) {
                if (trace) {
                    log.trace("Notifying task of thread completion, loadTask:" + loadTask);
                }
                task.finish();
                loadTaskThreadTasks.notify();
            }
        }
        if (trace) {
            log.trace("End nextTask(" + taskList.size() + "), loadTask=" + loadTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void scheduleTask(ClassLoadingTask task, Loader loader, boolean reschedule) {
        Object policy;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("ScheduleTask task=" + task + " loader=" + loader + " reschedule=" + reschedule);
        }
        boolean releaseInNextTask = false;
        BaseClassLoader classLoader = null;
        if (loader instanceof BaseDelegateLoader) {
            BaseDelegateLoader delegateLoader = (BaseDelegateLoader)loader;
            policy = delegateLoader.getPolicy();
            classLoader = ((BaseClassLoaderPolicy)policy).getClassLoader();
        }
        Map<BaseClassLoader, Thread> map = loadClassThreads;
        synchronized (map) {
            List<ClassLoadingTask.ThreadTask> taskList;
            Thread thread;
            if (classLoader == null) {
                thread = task.getRequestingThread();
                policy = loadTasksByThread;
                synchronized (policy) {
                    List<ClassLoadingTask.ThreadTask> list2 = loadTasksByThread.get(thread);
                    if (list2 == null) {
                        list2 = Collections.synchronizedList(new LinkedList());
                        loadTasksByThread.put(thread, list2);
                        if (trace) {
                            log.trace("Created new task list for " + thread);
                        }
                    }
                }
            } else {
                thread = loadClassThreads.get(classLoader);
            }
            if (thread == null) {
                boolean interrupted = Thread.interrupted();
                int waits = 0;
                try {
                    while (thread == null) {
                        try {
                            boolean gotLock = classLoader.attemptLock();
                            if (!gotLock) {
                                if (waits++ == 12) {
                                    throw new IllegalStateException("Waiting too long to get the registration lock for classLoader " + classLoader);
                                }
                                if (trace) {
                                    log.trace(classLoader + " waiting for lock");
                                }
                                loadClassThreads.wait(10000L);
                            } else {
                                releaseInNextTask = true;
                            }
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                        thread = loadClassThreads.get(classLoader);
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            ClassLoadingTask.ThreadTask subtask = task.newThreadTask(loader, thread, reschedule, releaseInNextTask);
            List<ClassLoadingTask.ThreadTask> list3 = taskList = loadTasksByThread.get(thread);
            synchronized (list3) {
                taskList.add(subtask);
                taskList.notify();
                if (trace) {
                    log.trace("scheduleTask(" + taskList.size() + "), created subtask: " + subtask);
                }
            }
        }
    }
}

