/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.inflow;

import javax.jms.MessageListener;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.inflow.JBossMessageEndpointFactory;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class JBossJMSMessageEndpointFactory
extends JBossMessageEndpointFactory {
    protected static String jmsra = "jms-ra.rar";

    protected String resolveResourceAdapterName() throws DeploymentException {
        String result = super.resolveResourceAdapterName();
        if (result == null) {
            result = jmsra;
        }
        return result;
    }

    protected void resolveMessageListener() throws DeploymentException {
        if (this.metaData.getMessagingType() == null) {
            this.messagingTypeClass = MessageListener.class;
        } else {
            super.resolveMessageListener();
        }
    }

    protected void augmentActivationConfigProperties() throws DeploymentException {
        super.augmentActivationConfigProperties();
        if (this.messagingTypeClass.equals(MessageListener.class)) {
            this.checkActivationConfig("destination", this.metaData.getDestinationJndiName());
            this.checkActivationConfig("destinationType", this.metaData.getDestinationType());
            this.checkActivationConfig("messageSelector", this.metaData.getMessageSelector());
            if (3 == this.metaData.getAcknowledgeMode()) {
                this.checkActivationConfig("acknowledgeMode", "DUPS_OK_ACKNOWLEDGE");
            } else {
                this.checkActivationConfig("acknowledgeMode", "AUTO_ACKNOWLEDGE");
            }
            if (0 == this.metaData.getSubscriptionDurability()) {
                this.checkActivationConfig("subscriptionDurability", "Durable");
            } else {
                this.checkActivationConfig("subscriptionDurability", "NonDurable");
            }
            this.checkActivationConfig("clientID", this.metaData.getClientId());
            this.checkActivationConfig("subscriptionName", this.metaData.getSubscriptionId());
            if (jmsra.equals(this.resourceAdapterName)) {
                this.checkActivationConfig("user", this.metaData.getUser());
                this.checkActivationConfig("password", this.metaData.getPasswd());
                Element proxyConfig = this.invokerMetaData.getProxyFactoryConfig();
                this.checkActivationConfig("maxMessages", MetaData.getOptionalChildContent(proxyConfig, "MaxMessages"));
                this.checkActivationConfig("minSession", MetaData.getOptionalChildContent(proxyConfig, "MinimumSize"));
                this.checkActivationConfig("maxSession", MetaData.getOptionalChildContent(proxyConfig, "MaximumSize"));
                this.checkActivationConfig("keepAlive", MetaData.getOptionalChildContent(proxyConfig, "KeepAliveMillis"));
                Element mdbConfig = MetaData.getOptionalChild(proxyConfig, "MDBConfig");
                if (mdbConfig != null) {
                    try {
                        if ("false".equalsIgnoreCase(MetaData.getElementContent(MetaData.getUniqueChild(mdbConfig, "DeliveryActive")))) {
                            this.setDeliveryActive(false);
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    this.checkActivationConfig("reconnectInterval", MetaData.getOptionalChildContent(proxyConfig, "ReconnectIntervalSec"));
                    this.checkActivationConfig("deliveryActive", MetaData.getOptionalChildContent(proxyConfig, "DeliveryActive"));
                    this.checkActivationConfig("providerAdapterJNDI", MetaData.getOptionalChildContent(proxyConfig, "JMSProviderAdapterJNDI"));
                    Element dlqEl = MetaData.getOptionalChild(mdbConfig, "DLQConfig");
                    if (dlqEl != null) {
                        this.checkActivationConfig("useDLQ", "true");
                        this.checkActivationConfig("DLQJNDIName", MetaData.getElementContent(MetaData.getUniqueChild(dlqEl, "DestinationQueue")));
                        try {
                            this.checkActivationConfig("DLQMaxResent", MetaData.getElementContent(MetaData.getUniqueChild(dlqEl, "MaxTimesRedelivered")));
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        this.checkActivationConfig("DLQUser", MetaData.getElementContent(MetaData.getOptionalChild(dlqEl, "DLQUser")));
                        this.checkActivationConfig("DLQPassword", MetaData.getElementContent(MetaData.getOptionalChild(dlqEl, "DLQPassword")));
                    } else {
                        this.checkActivationConfig("useDLQ", "false");
                    }
                }
            }
        }
    }

    void checkActivationConfig(String name, String value) {
        if (value != null && !this.properties.containsKey(name)) {
            org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData md = new org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData();
            ActivationConfigPropertyMetaData metaData = new ActivationConfigPropertyMetaData(md);
            md.setName(name);
            md.setValue(value);
            this.properties.put(name, metaData);
        }
    }
}

