/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import javax.ejb.ApplicationException;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.jboss.aop.Advisor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb.ApplicationExceptionImpl;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.ApplicationExceptionMetaData;
import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;
import org.jboss.tm.TransactionManagerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxUtil {
    public static TransactionManager getTransactionManager() throws RuntimeException {
        try {
            InitialContext jndiContext = InitialContextFactory.getInitialContext();
            TransactionManager tm = TransactionManagerLocator.getInstance().locate();
            return tm;
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to lookup TransactionManager", e);
        }
    }

    public static TransactionManagementType getTransactionManagementType(Advisor c) {
        TransactionManagement transactionManagement = (TransactionManagement)c.resolveAnnotation(TransactionManagement.class);
        if (transactionManagement == null) {
            return TransactionManagementType.CONTAINER;
        }
        return transactionManagement.value();
    }

    public static ApplicationException getApplicationException(Class<?> exceptionClass, Invocation invocation) {
        ApplicationExceptionsMetaData exceptions;
        MethodInvocation ejb = (MethodInvocation)invocation;
        EJBContainer container = (EJBContainer)ejb.getAdvisor();
        if (exceptionClass.isAnnotationPresent(ApplicationException.class)) {
            return exceptionClass.getAnnotation(ApplicationException.class);
        }
        JBossAssemblyDescriptorMetaData assembly = container.getAssemblyDescriptor();
        if (assembly != null && (exceptions = assembly.getApplicationExceptions()) != null) {
            for (ApplicationExceptionMetaData exception : exceptions) {
                if (!exception.getExceptionClass().equals(exceptionClass.getName())) continue;
                return new ApplicationExceptionImpl(exception.isRollback());
            }
        }
        return null;
    }
}

