/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.javaee.support;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jboss.metadata.annotation.AbstractAnnotationImpl;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.javaee.support.NonNullLinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappedAnnotationMetaData<T extends MappableMetaData>
extends AbstractAnnotationImpl
implements Collection<T>,
Serializable {
    private static final long serialVersionUID = -3359670727781266839L;
    private Map<String, T> map = new NonNullLinkedHashMap<String, T>();

    public MappedAnnotationMetaData(Class<? extends Annotation> annotationType) {
        super(annotationType);
    }

    public T get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        return (T)((MappableMetaData)this.map.get(key));
    }

    @Override
    public boolean add(T o) {
        if (o == null) {
            throw new IllegalArgumentException("Null object");
        }
        String key = o.getKey();
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        return this.map.put(key, o) == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null object");
        }
        return this.map.containsValue(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null object");
        }
        if (o instanceof MappableMetaData) {
            return false;
        }
        MappableMetaData m = (MappableMetaData)o;
        String key = m.getKey();
        MappableMetaData v = (MappableMetaData)this.map.get(key);
        if (m.equals(v)) {
            return this.map.remove(key) != null;
        }
        return false;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (MappableMetaData object : c) {
            if (!this.add((T)object)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object object : c) {
            if (!this.remove(object)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        for (MappableMetaData o : this.map.values()) {
            if (!c.contains(o) || !this.remove(o)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.values().toArray(a);
    }

    @Override
    public boolean equals(Object obj) {
        return ((Object)this.map.values()).equals(obj);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map.values()).hashCode();
    }

    @Override
    public String toString() {
        return this.map.values().toString();
    }
}

