/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.config.factories;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.PortUtil;
import org.w3c.dom.Document;

public class FactoryConfigSample
extends TestCase {
    protected static Logger log = Logger.getLogger(FactoryConfigSample.class);

    public void testFactoriesBySettingInvokers() {
        try {
            HashMap<String, String> sconfig = new HashMap<String, String>();
            sconfig.put("force_remote", "true");
            int freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator locator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector connector = new Connector(locator, sconfig);
            connector.create();
            ServerInvoker serverInvoker = connector.getServerInvoker();
            ServerSocketFactory ssf1 = this.getDefaultServerSocketFactory();
            serverInvoker.setServerSocketFactory(ssf1);
            SocketFactory sf1 = this.getDefaultCallbackSocketFactory();
            serverInvoker.setSocketFactory(sf1);
            connector.addInvocationHandler("sample", new SampleInvocationHandler());
            connector.start();
            HashMap<String, String> cconfig = new HashMap<String, String>();
            cconfig.put("force_remote", "true");
            Client client = new Client(locator, cconfig);
            client.connect();
            SocketFactory sf2 = this.getDefaultSocketFactory();
            ClientInvoker clientInvoker = client.getInvoker();
            clientInvoker.setSocketFactory(sf2);
            System.out.println(this.getName() + ": " + client.invoke("test invoke()"));
            freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator callbackLocator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector callbackConnector = new Connector(callbackLocator.getLocatorURI());
            callbackConnector.create();
            ServerInvoker callbackServerInvoker = callbackConnector.getServerInvoker();
            ServerSocketFactory ssf2 = this.getDefaultCallbackServerSocketFactory();
            callbackServerInvoker.setServerSocketFactory(ssf2);
            callbackConnector.addInvocationHandler("sample", new SampleInvocationHandler());
            callbackConnector.start();
            CallbackHandler callbackHandler = new CallbackHandler();
            String callbackHandleObject = "myCallbackHandleObject";
            client.addListener((InvokerCallbackHandler)callbackHandler, callbackLocator, (Object)callbackHandleObject);
            client.disconnect();
            callbackConnector.stop();
            connector.stop();
        }
        catch (Throwable t) {
            log.error(t);
            t.printStackTrace();
            FactoryConfigSample.fail();
        }
    }

    public void testFactoriesBySettingConnectorAndClient() {
        try {
            HashMap<String, String> sconfig = new HashMap<String, String>();
            sconfig.put("force_remote", "true");
            int freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator locator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector connector = new Connector(locator, sconfig);
            ServerSocketFactory ssf1 = this.getDefaultServerSocketFactory();
            connector.setServerSocketFactory(ssf1);
            SocketFactory sf1 = this.getDefaultCallbackSocketFactory();
            connector.setSocketFactory(sf1);
            connector.create();
            connector.addInvocationHandler("sample", new SampleInvocationHandler());
            connector.start();
            HashMap<String, String> cconfig = new HashMap<String, String>();
            cconfig.put("force_remote", "true");
            Client client = new Client(locator, cconfig);
            SocketFactory sf2 = this.getDefaultSocketFactory();
            client.setSocketFactory(sf2);
            client.connect();
            System.out.println(this.getName() + ": " + client.invoke("test invoke()"));
            freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator callbackLocator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector callbackConnector = new Connector(callbackLocator.getLocatorURI());
            ServerSocketFactory ssf2 = this.getDefaultCallbackServerSocketFactory();
            callbackConnector.setServerSocketFactory(ssf2);
            callbackConnector.create();
            callbackConnector.addInvocationHandler("sample", new SampleInvocationHandler());
            callbackConnector.start();
            CallbackHandler callbackHandler = new CallbackHandler();
            String callbackHandleObject = "myCallbackHandleObject";
            client.addListener((InvokerCallbackHandler)callbackHandler, callbackLocator, (Object)callbackHandleObject);
            client.disconnect();
            callbackConnector.stop();
            connector.stop();
        }
        catch (Throwable t) {
            log.error(t);
            t.printStackTrace();
            FactoryConfigSample.fail();
        }
    }

    public void testFactoriesByPassingInConfig() {
        try {
            HashMap<String, Object> sconfig = new HashMap<String, Object>();
            ServerSocketFactory ssf1 = this.getDefaultServerSocketFactory();
            sconfig.put("customServerSocketFactory", ssf1);
            SocketFactory sf1 = this.getDefaultCallbackSocketFactory();
            sconfig.put("customSocketFactory", sf1);
            sconfig.put("force_remote", "true");
            int freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator locator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector connector = new Connector(locator, sconfig);
            connector.create();
            connector.addInvocationHandler("sample", new SampleInvocationHandler());
            connector.start();
            HashMap<String, Object> cconfig = new HashMap<String, Object>();
            SocketFactory sf2 = this.getDefaultSocketFactory();
            cconfig.put("customSocketFactory", sf2);
            cconfig.put("force_remote", "true");
            Client client = new Client(locator, cconfig);
            client.connect();
            System.out.println(this.getName() + ": " + client.invoke("test invoke()"));
            HashMap<String, ServerSocketFactory> cbconfig = new HashMap<String, ServerSocketFactory>();
            ServerSocketFactory ssf2 = this.getDefaultCallbackServerSocketFactory();
            cbconfig.put("customServerSocketFactory", ssf2);
            freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator callbackLocator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector callbackConnector = new Connector(callbackLocator.getLocatorURI(), cbconfig);
            callbackConnector.create();
            callbackConnector.addInvocationHandler("sample", new SampleInvocationHandler());
            callbackConnector.start();
            CallbackHandler callbackHandler = new CallbackHandler();
            String callbackHandleObject = "myCallbackHandleObject";
            client.addListener((InvokerCallbackHandler)callbackHandler, callbackLocator, (Object)callbackHandleObject);
            client.disconnect();
            callbackConnector.stop();
            connector.stop();
        }
        catch (Throwable t) {
            log.error(t);
            t.printStackTrace();
            FactoryConfigSample.fail();
        }
    }

    public void testFactoriesByPassingClassnameInXml() {
        try {
            HashMap<String, String> sconfig = new HashMap<String, String>();
            sconfig.put("force_remote", "true");
            int freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator locator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector connector = new Connector(sconfig);
            StringBuffer buf = new StringBuffer();
            buf.append("<?xml version=\"1.0\"?>\n");
            buf.append("<config>");
            buf.append("<invoker transport=\"" + this.getTransport() + "\">");
            buf.append("<attribute name=\"serverBindAddress\">" + this.getHostName() + "</attribute>");
            buf.append("<attribute name=\"serverBindPort\">" + freeport + "</attribute>");
            buf.append("<attribute name=\"serverSocketFactory\">");
            buf.append(this.getDefaultServerSocketFactoryClass().getName());
            buf.append("</attribute>");
            buf.append("<attribute name=\"socketFactory\">");
            buf.append(this.getDefaultSocketFactoryClass().getName());
            buf.append("</attribute>");
            buf.append("</invoker>");
            buf.append("</config>");
            ByteArrayInputStream bais = new ByteArrayInputStream(buf.toString().getBytes());
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
            connector.setConfiguration(xml.getDocumentElement());
            connector.create();
            connector.addInvocationHandler("sample", new SampleInvocationHandler());
            connector.start();
            HashMap<String, String> cconfig = new HashMap<String, String>();
            cconfig.put("force_remote", "true");
            Client client = new Client(locator, cconfig);
            SocketFactory sf = this.getDefaultSocketFactory();
            client.setSocketFactory(sf);
            client.connect();
            System.out.println(this.getName() + ": " + client.invoke("test invoke()"));
            freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator callbackLocator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector callbackConnector = new Connector();
            buf = new StringBuffer();
            buf.append("<?xml version=\"1.0\"?>\n");
            buf.append("<config>");
            buf.append("<invoker transport=\"" + this.getTransport() + "\">");
            buf.append("<attribute name=\"serverBindAddress\">" + this.getHostName() + "</attribute>");
            buf.append("<attribute name=\"serverBindPort\">" + freeport + "</attribute>");
            buf.append("<attribute name=\"serverSocketFactory\">");
            buf.append(this.getDefaultCallbackServerSocketFactoryClass().getName());
            buf.append("</attribute>");
            buf.append("</invoker>");
            buf.append("</config>");
            bais = new ByteArrayInputStream(buf.toString().getBytes());
            xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
            callbackConnector.setConfiguration(xml.getDocumentElement());
            callbackConnector.create();
            callbackConnector.addInvocationHandler("sample", new SampleInvocationHandler());
            callbackConnector.start();
            CallbackHandler callbackHandler = new CallbackHandler();
            String callbackHandleObject = "myCallbackHandleObject";
            client.addListener((InvokerCallbackHandler)callbackHandler, callbackLocator, (Object)callbackHandleObject);
            client.disconnect();
            callbackConnector.stop();
            connector.stop();
        }
        catch (Throwable t) {
            log.error(t);
            t.printStackTrace();
            FactoryConfigSample.fail();
        }
    }

    public void testFactoriesByClassNameinConfig() {
        try {
            HashMap<String, String> sconfig = new HashMap<String, String>();
            sconfig.put("serverSocketFactory", this.getDefaultServerSocketFactoryClass().getName());
            sconfig.put("socketFactory", this.getDefaultCallbackSocketFactoryClass().getName());
            sconfig.put("force_remote", "true");
            int freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator locator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector connector = new Connector(locator, sconfig);
            connector.create();
            connector.addInvocationHandler("sample", new SampleInvocationHandler());
            connector.start();
            HashMap<String, String> cconfig = new HashMap<String, String>();
            cconfig.put("socketFactory", this.getDefaultSocketFactoryClass().getName());
            cconfig.put("force_remote", "true");
            Client client = new Client(locator, cconfig);
            client.connect();
            System.out.println(this.getName() + ": " + client.invoke("test invoke()"));
            HashMap<String, String> cbconfig = new HashMap<String, String>();
            cbconfig.put("serverSocketFactory", this.getDefaultCallbackServerSocketFactoryClass().getName());
            freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator callbackLocator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector callbackConnector = new Connector(callbackLocator.getLocatorURI(), cbconfig);
            callbackConnector.create();
            callbackConnector.addInvocationHandler("sample", new SampleInvocationHandler());
            callbackConnector.start();
            CallbackHandler callbackHandler = new CallbackHandler();
            String callbackHandleObject = "myCallbackHandleObject";
            client.addListener((InvokerCallbackHandler)callbackHandler, callbackLocator, (Object)callbackHandleObject);
            client.disconnect();
            callbackConnector.stop();
            connector.stop();
        }
        catch (Throwable t) {
            log.error(t);
            t.printStackTrace();
            FactoryConfigSample.fail();
        }
    }

    protected String getTransport() {
        return "socket";
    }

    protected String getHostName() {
        return "localhost";
    }

    protected ServerSocketFactory getDefaultServerSocketFactory() throws Exception {
        return new SampleServerSocketFactory();
    }

    protected SocketFactory getDefaultSocketFactory() throws Exception {
        return new SampleSocketFactory();
    }

    protected ServerSocketFactory getDefaultCallbackServerSocketFactory() throws Exception {
        return new SampleServerSocketFactory();
    }

    protected SocketFactory getDefaultCallbackSocketFactory() throws Exception {
        return new SampleSocketFactory();
    }

    protected Class getDefaultServerSocketFactoryClass() throws Exception {
        return SampleServerSocketFactory.class;
    }

    protected Class getDefaultSocketFactoryClass() throws Exception {
        return SampleSocketFactory.class;
    }

    protected Class getDefaultCallbackServerSocketFactoryClass() throws Exception {
        return SampleServerSocketFactory.class;
    }

    protected Class getDefaultCallbackSocketFactoryClass() throws Exception {
        return SampleSocketFactory.class;
    }

    public static class CallbackHandler
    implements InvokerCallbackHandler {
        public void handleCallback(Callback callback) throws HandleCallbackException {
            System.out.println("Received callback value of: " + callback.getCallbackObject());
        }
    }

    public static class SampleInvocationHandler
    implements ServerInvocationHandler {
        private InvokerCallbackHandler callbackHandler;

        public Object invoke(InvocationRequest invocation) throws Throwable {
            return invocation.getParameter();
        }

        public void addListener(InvokerCallbackHandler callbackHandler) {
            log.info("entering addListener()");
            this.callbackHandler = callbackHandler;
            try {
                Callback callback = new Callback(new Integer(1));
                callbackHandler.handleCallback(callback);
                log.info("sent first callback");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void removeListener(InvokerCallbackHandler callbackHandler) {
        }

        public void setMBeanServer(MBeanServer server) {
        }

        public void setInvoker(ServerInvoker invoker) {
        }

        public InvokerCallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }
    }

    public static class SampleSocketFactory
    extends SocketFactory {
        public Socket createSocket(String arg0, int arg1) throws IOException, UnknownHostException {
            return new Socket(arg0, arg1);
        }

        public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
            return new Socket(arg0, arg1, arg2, arg3);
        }

        public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
            return new Socket(arg0, arg1);
        }

        public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
            return new Socket(arg0, arg1, arg2, arg3);
        }
    }

    public static class SampleServerSocketFactory
    extends ServerSocketFactory {
        public ServerSocket createServerSocket(int arg0) throws IOException {
            return new ServerSocket(arg0);
        }

        public ServerSocket createServerSocket(int arg0, int arg1) throws IOException {
            return new ServerSocket(arg0, arg1);
        }

        public ServerSocket createServerSocket(int arg0, int arg1, InetAddress arg2) throws IOException {
            return new ServerSocket(arg0, arg1, arg2);
        }
    }
}

