/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers;

import java.util.ArrayList;
import javax.management.ObjectName;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.resource.deployers.RARDeployment;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceInjectionValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RARDeployer
extends AbstractSimpleRealDeployer<ConnectorMetaData> {
    private String workManagerName;
    private String xaTerminatorName;

    public RARDeployer() {
        super(ConnectorMetaData.class);
        this.setOutput(ServiceMetaData.class);
    }

    public String getWorkManagerName() {
        return this.workManagerName;
    }

    public void setWorkManagerName(String workManagerName) {
        this.workManagerName = workManagerName;
    }

    public String getXATerminatorName() {
        return this.xaTerminatorName;
    }

    public void setXATerminatorName(String xaTerminatorName) {
        this.xaTerminatorName = xaTerminatorName;
    }

    protected String getObjectName(DeploymentUnit unit, ConnectorMetaData cmd) {
        String name = unit.getSimpleName();
        for (unit = unit.getParent(); unit != null; unit = unit.getParent()) {
            name = unit.getSimpleName() + "#" + name;
        }
        return "jboss.jca:service=RARDeployment,name='" + name + "'";
    }

    @Override
    public void deploy(DeploymentUnit unit, ConnectorMetaData cmd) throws DeploymentException {
        try {
            ServiceMetaData rarDeployment = new ServiceMetaData();
            String name = this.getObjectName(unit, cmd);
            ObjectName objectName = new ObjectName(name);
            rarDeployment.setObjectName(objectName);
            rarDeployment.setCode(RARDeployment.class.getName());
            ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
            constructor.setSignature(new String[]{ConnectorMetaData.class.getName()});
            constructor.setParameters(new Object[]{cmd});
            rarDeployment.setConstructor(constructor);
            ArrayList<ServiceAttributeMetaData> attributes = new ArrayList<ServiceAttributeMetaData>();
            ServiceAttributeMetaData attribute = null;
            if (this.workManagerName != null) {
                attribute = new ServiceAttributeMetaData();
                attribute.setName("WorkManager");
                attribute.setValue(new ServiceInjectionValueMetaData(this.workManagerName));
                attributes.add(attribute);
            }
            if (this.xaTerminatorName != null) {
                attribute = new ServiceAttributeMetaData();
                attribute.setName("XATerminator");
                attribute.setValue(new ServiceInjectionValueMetaData(this.xaTerminatorName, "XATerminator"));
                attributes.add(attribute);
            }
            if (!attributes.isEmpty()) {
                rarDeployment.setAttributes(attributes);
            }
            unit.addAttachment(ServiceMetaData.class, rarDeployment);
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException("Error creating rar deployment " + unit.getName(), e);
        }
    }

    @Override
    public void undeploy(DeploymentUnit unit, ConnectorMetaData cmd) {
    }
}

