/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import java.io.Serializable;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.system.metadata.AbstractMetaDataVisitorNode;
import org.jboss.system.metadata.ServiceMetaDataVisitor;
import org.jboss.system.metadata.ServiceValueContext;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.system.microcontainer.ServiceControllerContext;

public class ServiceInjectionValueMetaData
extends AbstractMetaDataVisitorNode
implements ServiceValueMetaData,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Object dependency;
    private String property;
    private ControllerState dependentState = ControllerState.INSTALLED;

    public ServiceInjectionValueMetaData() {
    }

    public ServiceInjectionValueMetaData(Object dependency) {
        this(dependency, null);
    }

    public ServiceInjectionValueMetaData(Object dependency, String property) {
        this(dependency, property, ControllerState.INSTALLED);
    }

    public ServiceInjectionValueMetaData(Object dependency, String property, ControllerState dependentState) {
        this.setDependency(dependency);
        this.setProperty(property);
        this.setDependentState(dependentState);
    }

    public Object getDependency() {
        return this.dependency;
    }

    public void setDependency(Object dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("Null dependency");
        }
        this.dependency = dependency;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public void setDependentState(ControllerState dependentState) {
        this.dependentState = dependentState;
    }

    public Object getValue(ServiceValueContext valueContext) throws Throwable {
        ControllerContext context;
        KernelController controller = valueContext.getController();
        ControllerState state = this.dependentState;
        if (state == null) {
            state = ControllerState.INSTALLED;
        }
        if ((context = controller.getContext(this.dependency, state)) == null) {
            throw new Error("Should not be here - dependency failed! " + this);
        }
        Object result = context.getTarget();
        if (this.property != null) {
            if (context instanceof AttributeDispatchContext) {
                AttributeDispatchContext adc = (AttributeDispatchContext)((Object)context);
                result = adc.get(this.property);
            } else {
                throw new IllegalArgumentException("Cannot use property attribute, context is not AttributeDispatchContext: " + context + ", metadata: " + this);
            }
        }
        return result;
    }

    public void visit(ServiceMetaDataVisitor visitor) {
        ServiceControllerContext context = visitor.getControllerContext();
        Object name = context.getName();
        ControllerState whenRequired = visitor.getContextState();
        AbstractDependencyItem item = new AbstractDependencyItem(name, this.dependency, whenRequired, this.dependentState);
        visitor.addDependency(item);
        visitor.visit(this);
    }
}

