/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.system.server.ServerInfoMBean;
import org.jboss.util.platform.Java;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerInfo
implements ServerInfoMBean,
MBeanRegistration {
    private static final Logger log = Logger.getLogger(ServerInfo.class);
    private static final Integer ZERO = new Integer(0);
    private static final Class[] NO_PARAMS_SIG = new Class[0];
    private static final Object[] NO_PARAMS = new Object[0];
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private String hostName;
    private String hostAddress;
    private Object threadMXBean;
    private Method getMemoryPoolMXBeans;
    private Method getName;
    private Method getType;
    private Method getUsage;
    private Method getPeakUsage;
    private Method getInit;
    private Method getUsed;
    private Method getCommitted;
    private Method getMax;
    private Method getThreadInfo;
    private Method getAllThreadIds;
    private Method getThreadCpuTime;
    private Method getThreadName;
    private Method getThreadState;
    private Method getLockName;
    private Method getStackTrace;
    private Method getThreadId;

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        log.info("Java version: " + System.getProperty("java.version") + "," + System.getProperty("java.vendor"));
        log.info("Java VM: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "," + System.getProperty("java.vm.vendor"));
        log.info("OS-System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "," + System.getProperty("os.arch"));
        log.debug("Full System Properties Dump");
        Enumeration<?> names = System.getProperties().propertyNames();
        while (names.hasMoreElements()) {
            String pname = (String)names.nextElement();
            log.debug("    " + pname + ": " + System.getProperty(pname));
        }
        if (Java.isCompatible(6)) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<Object> clazz = cl.loadClass("java.lang.management.ManagementFactory");
                Method method = clazz.getMethod("getThreadMXBean", NO_PARAMS_SIG);
                this.threadMXBean = method.invoke(null, NO_PARAMS);
                this.getMemoryPoolMXBeans = clazz.getMethod("getMemoryPoolMXBeans", NO_PARAMS_SIG);
                clazz = cl.loadClass("java.lang.management.MemoryPoolMXBean");
                this.getName = clazz.getMethod("getName", NO_PARAMS_SIG);
                this.getType = clazz.getMethod("getType", NO_PARAMS_SIG);
                this.getUsage = clazz.getMethod("getUsage", NO_PARAMS_SIG);
                this.getPeakUsage = clazz.getMethod("getPeakUsage", NO_PARAMS_SIG);
                clazz = cl.loadClass("java.lang.management.MemoryUsage");
                this.getInit = clazz.getMethod("getInit", NO_PARAMS_SIG);
                this.getUsed = clazz.getMethod("getUsed", NO_PARAMS_SIG);
                this.getCommitted = clazz.getMethod("getCommitted", NO_PARAMS_SIG);
                this.getMax = clazz.getMethod("getMax", NO_PARAMS_SIG);
                clazz = cl.loadClass("java.lang.management.ThreadMXBean");
                this.getThreadInfo = clazz.getMethod("getThreadInfo", Long.TYPE, Integer.TYPE);
                this.getAllThreadIds = clazz.getMethod("getAllThreadIds", NO_PARAMS_SIG);
                this.getThreadCpuTime = clazz.getMethod("getThreadCpuTime", Long.TYPE);
                clazz = cl.loadClass("java.lang.management.ThreadInfo");
                this.getThreadName = clazz.getMethod("getThreadName", NO_PARAMS_SIG);
                this.getThreadState = clazz.getMethod("getThreadState", NO_PARAMS_SIG);
                this.getLockName = clazz.getMethod("getLockName", NO_PARAMS_SIG);
                this.getStackTrace = clazz.getMethod("getStackTrace", NO_PARAMS_SIG);
                clazz = Thread.class;
                this.getThreadId = clazz.getMethod("getId", NO_PARAMS_SIG);
            }
            catch (Exception e) {
                log.debug("Cannot access platform ThreadMXBean", e);
            }
        }
        return name == null ? new ObjectName("jboss.system:type=ServerInfo") : name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    @Override
    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    @Override
    public String getJavaVMName() {
        return System.getProperty("java.vm.name");
    }

    @Override
    public String getJavaVMVersion() {
        return System.getProperty("java.vm.version");
    }

    @Override
    public String getJavaVMVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @Override
    public String getOSName() {
        return System.getProperty("os.name");
    }

    @Override
    public String getOSVersion() {
        return System.getProperty("os.version");
    }

    @Override
    public String getOSArch() {
        return System.getProperty("os.arch");
    }

    @Override
    public Long getTotalMemory() {
        return new Long(Runtime.getRuntime().totalMemory());
    }

    @Override
    public Long getFreeMemory() {
        return new Long(Runtime.getRuntime().freeMemory());
    }

    @Override
    public Long getMaxMemory() {
        if (Java.isCompatible(5)) {
            try {
                Runtime rt = Runtime.getRuntime();
                Method m = rt.getClass().getMethod("maxMemory", NO_PARAMS_SIG);
                return (Long)m.invoke((Object)rt, NO_PARAMS);
            }
            catch (Exception e) {
                log.error("Operation failed", e);
            }
        }
        return new Long(-1L);
    }

    @Override
    public Integer getAvailableProcessors() {
        if (Java.isCompatible(5)) {
            try {
                Runtime rt = Runtime.getRuntime();
                Method m = rt.getClass().getMethod("availableProcessors", NO_PARAMS_SIG);
                return (Integer)m.invoke((Object)rt, NO_PARAMS);
            }
            catch (Exception e) {
                log.error("Operation failed", e);
            }
        }
        return new Integer(-1);
    }

    @Override
    public String getHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.error("Error looking up local hostname", e);
                this.hostName = "<unknown>";
            }
        }
        return this.hostName;
    }

    @Override
    public String getHostAddress() {
        if (this.hostAddress == null) {
            try {
                this.hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                log.error("Error looking up local address", e);
                this.hostAddress = "<unknown>";
            }
        }
        return this.hostAddress;
    }

    @Override
    public String listMemoryPools(boolean fancy) {
        if (this.getMemoryPoolMXBeans != null) {
            StringBuffer sbuf = new StringBuffer(4196);
            try {
                List poolList = (List)this.getMemoryPoolMXBeans.invoke(null, NO_PARAMS);
                sbuf.append("<b>Total Memory Pools:</b> ").append(poolList.size());
                sbuf.append("<blockquote>");
                for (Object pool : poolList) {
                    String name = (String)this.getName.invoke(pool, NO_PARAMS);
                    Object type = this.getType.invoke(pool, NO_PARAMS);
                    sbuf.append("<b>Pool: ").append(name);
                    sbuf.append("</b> (").append(type).append(")");
                    Object peakUsage = this.getPeakUsage.invoke(pool, NO_PARAMS);
                    Object usage = this.getUsage.invoke(pool, NO_PARAMS);
                    sbuf.append("<blockquote>");
                    if (usage != null && peakUsage != null) {
                        Long init = (Long)this.getInit.invoke(peakUsage, NO_PARAMS);
                        Long used = (Long)this.getUsed.invoke(peakUsage, NO_PARAMS);
                        Long committed = (Long)this.getCommitted.invoke(peakUsage, NO_PARAMS);
                        Long max = (Long)this.getMax.invoke(peakUsage, NO_PARAMS);
                        sbuf.append("Peak Usage    : ");
                        sbuf.append("init:").append(init);
                        sbuf.append(", used:").append(used);
                        sbuf.append(", committed:").append(committed);
                        sbuf.append(", max:").append(max);
                        sbuf.append("<br>");
                        init = (Long)this.getInit.invoke(usage, NO_PARAMS);
                        used = (Long)this.getUsed.invoke(usage, NO_PARAMS);
                        committed = (Long)this.getCommitted.invoke(usage, NO_PARAMS);
                        max = (Long)this.getMax.invoke(usage, NO_PARAMS);
                        sbuf.append("Current Usage : ");
                        sbuf.append("init:").append(init);
                        sbuf.append(", used:").append(used);
                        sbuf.append(", committed:").append(committed);
                        sbuf.append(", max:").append(max);
                        if (fancy) {
                            TextGraphHelper.poolUsage(sbuf, used, committed, max);
                        }
                    } else {
                        sbuf.append("Memory pool NOT valid!");
                    }
                    sbuf.append("</blockquote><br>");
                }
                sbuf.append("</blockquote>");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sbuf.toString();
        }
        return "<b>Memory pool information available only under a JDK5+ compatible JVM!</b>";
    }

    @Override
    public Integer getActiveThreadCount() {
        return new Integer(this.getRootThreadGroup().activeCount());
    }

    @Override
    public Integer getActiveThreadGroupCount() {
        return new Integer(this.getRootThreadGroup().activeGroupCount());
    }

    @Override
    public String listThreadDump() {
        ThreadGroup root = this.getRootThreadGroup();
        ThreadGroupCount count = new ThreadGroupCount();
        String threadGroupInfo = this.getThreadGroupInfo(root, count);
        String threadDump = "<b>Total Threads:</b> " + count.threads + "<br>" + "<b>Total Thread Groups:</b> " + count.groups + "<br>" + "<b>Timestamp:</b> " + dateFormat.format(new Date()) + "<br>" + threadGroupInfo;
        return threadDump;
    }

    @Override
    public String listThreadCpuUtilization() {
        Set<ThreadCPU> threads = this.getThreadCpuUtilization();
        if (threads == null) {
            return "Thread cpu utilization requires J2SE5+";
        }
        long totalCPU = 0L;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table><tr><th>Thread Name</th><th>CPU (milliseconds)</th></tr>");
        for (ThreadCPU thread : threads) {
            buffer.append("<tr><td>").append(thread.name).append("</td><td>");
            buffer.append(thread.cpuTime).append("</td></tr>");
            totalCPU += thread.cpuTime;
        }
        buffer.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td>Total</td><td>");
        buffer.append(totalCPU).append("</td></tr></table>");
        return buffer.toString();
    }

    private Set<ThreadCPU> getThreadCpuUtilization() {
        if (this.threadMXBean == null) {
            return null;
        }
        try {
            TreeSet<ThreadCPU> result = new TreeSet<ThreadCPU>();
            long[] threads = (long[])this.getAllThreadIds.invoke(this.threadMXBean, NO_PARAMS);
            for (int i = 0; i < threads.length; ++i) {
                Long id = new Long(threads[i]);
                Long cpuTime = (Long)this.getThreadCpuTime.invoke(this.threadMXBean, id);
                Object threadInfo = this.getThreadInfo.invoke(this.threadMXBean, id, ZERO);
                if (threadInfo == null) continue;
                String name = (String)this.getThreadName.invoke(threadInfo, NO_PARAMS);
                result.add(new ThreadCPU(name, cpuTime));
            }
            return result;
        }
        catch (Exception e) {
            log.warn("Error retrieving thread cpu utiliation", e);
            return null;
        }
    }

    private ThreadGroup getRootThreadGroup() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        return group;
    }

    private String getThreadGroupInfo(ThreadGroup group, ThreadGroupCount count) {
        StringBuffer rc = new StringBuffer();
        ++count.groups;
        rc.append("<br><b>");
        rc.append("Thread Group: " + group.getName());
        rc.append("</b> : ");
        rc.append("max priority:" + group.getMaxPriority() + ", demon:" + group.isDaemon());
        rc.append("<blockquote>");
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads, false);
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            ++count.threads;
            rc.append("<b>");
            rc.append("Thread: " + threads[i].getName());
            rc.append("</b> : ");
            rc.append("priority:" + threads[i].getPriority() + ", demon:" + threads[i].isDaemon());
            this.outputJdk5ThreadMXBeanInfo(rc, threads[i]);
        }
        ThreadGroup[] groups = new ThreadGroup[group.activeGroupCount()];
        group.enumerate(groups, false);
        for (int i = 0; i < groups.length && groups[i] != null; ++i) {
            rc.append(this.getThreadGroupInfo(groups[i], count));
        }
        rc.append("</blockquote>");
        return rc.toString();
    }

    private void outputJdk5ThreadMXBeanInfo(StringBuffer sbuf, Thread thread) {
        block7: {
            if (this.threadMXBean != null) {
                try {
                    Long threadId = (Long)this.getThreadId.invoke((Object)thread, NO_PARAMS);
                    sbuf.append(", threadId:").append(threadId);
                    Object threadInfo = this.getThreadInfo.invoke(this.threadMXBean, threadId, new Integer(Integer.MAX_VALUE));
                    if (threadInfo != null) {
                        Object threadState = this.getThreadState.invoke(threadInfo, NO_PARAMS);
                        String lockName = (String)this.getLockName.invoke(threadInfo, NO_PARAMS);
                        Object[] stackTrace = (Object[])this.getStackTrace.invoke(threadInfo, NO_PARAMS);
                        sbuf.append(", threadState:").append(threadState);
                        sbuf.append(", lockName:").append(lockName);
                        sbuf.append("<br>");
                        if (stackTrace.length > 0) {
                            sbuf.append("<blockquote>");
                            for (int i = 0; i < stackTrace.length; ++i) {
                                sbuf.append(stackTrace[i]).append("<br>");
                            }
                            sbuf.append("</blockquote>");
                        }
                        break block7;
                    }
                    sbuf.append("<br>");
                }
                catch (Exception exception) {}
            } else {
                sbuf.append("<br>");
            }
        }
    }

    @Override
    public String displayPackageInfo(String pkgName) {
        Package pkg = Package.getPackage(pkgName);
        if (pkg == null) {
            return "<h2>Package:" + pkgName + " Not Found!</h2>";
        }
        StringBuffer info = new StringBuffer("<h2>Package: " + pkgName + "</h2>");
        this.displayPackageInfo(pkg, info);
        return info.toString();
    }

    private void displayPackageInfo(Package pkg, StringBuffer info) {
        info.append("<pre>\n");
        info.append("SpecificationTitle: " + pkg.getSpecificationTitle());
        info.append("\nSpecificationVersion: " + pkg.getSpecificationVersion());
        info.append("\nSpecificationVendor: " + pkg.getSpecificationVendor());
        info.append("\nImplementationTitle: " + pkg.getImplementationTitle());
        info.append("\nImplementationVersion: " + pkg.getImplementationVersion());
        info.append("\nImplementationVendor: " + pkg.getImplementationVendor());
        info.append("\nisSealed: " + pkg.isSealed());
        info.append("</pre>\n");
    }

    private static class ThreadGroupCount {
        public int threads;
        public int groups;

        private ThreadGroupCount() {
        }
    }

    private static class ThreadCPU
    implements Comparable {
        public String name;
        public long cpuTime;

        public ThreadCPU(String name, long cpuTime) {
            this.name = name;
            this.cpuTime = cpuTime / 1000000L;
        }

        public int compareTo(Object o) {
            ThreadCPU other = (ThreadCPU)o;
            long value = this.cpuTime - other.cpuTime;
            if (value > 0L) {
                return -1;
            }
            if (value < 0L) {
                return 1;
            }
            return this.name.compareTo(other.name);
        }
    }

    private static class TextGraphHelper {
        static final DecimalFormat formatter = new DecimalFormat("#.##");
        static final long KILO = 1024L;
        static final long MEGA = 0x100000L;
        static final long GIGA = 0x40000000L;
        static final int factor = 70;
        static char[] fixedline;
        static char[] baseline;
        static char[] barline;
        static char[] spaces;

        private TextGraphHelper() {
        }

        public static void poolUsage(StringBuffer sbuf, long used, long committed, long max) {
            long assumedMax = max == -1L ? committed : max;
            int localUsed = (int)(70L * used / assumedMax);
            int localCommitted = (int)(70L * committed / assumedMax);
            int localMax = 70;
            sbuf.append("<blockquote><br>");
            sbuf.append(baseline, 0, localCommitted).append("| committed:").append(TextGraphHelper.outputNumber(committed)).append("<br>");
            sbuf.append(fixedline).append("<br>");
            sbuf.append(barline, 0, localUsed);
            if (localUsed < localCommitted) {
                sbuf.append(localUsed > 0 ? (char)'/' : '|');
                sbuf.append(spaces, 0, localCommitted - localUsed - 1);
            }
            sbuf.append('|');
            if (localCommitted < localMax) {
                sbuf.append(spaces, 0, localMax - localCommitted - 1);
                sbuf.append('|');
            }
            sbuf.append(" max:").append(TextGraphHelper.outputNumber(max)).append("<br>");
            sbuf.append(fixedline).append("<br>");
            sbuf.append(baseline, 0, localUsed).append("| used:").append(TextGraphHelper.outputNumber(used));
            sbuf.append("</blockquote>");
        }

        private static String outputNumber(long value) {
            if (value >= 0x40000000L) {
                return formatter.format((double)value / 1.073741824E9) + "Gb";
            }
            if (value >= 0x100000L) {
                return formatter.format((double)value / 1048576.0) + "Mb";
            }
            if (value >= 1024L) {
                return formatter.format((double)value / 1024.0) + "Kb";
            }
            if (value >= 0L) {
                return value + "b";
            }
            return Long.toString(value);
        }

        static {
            StringBuffer sbuf0 = new StringBuffer();
            StringBuffer sbuf1 = new StringBuffer();
            StringBuffer sbuf2 = new StringBuffer();
            StringBuffer sbuf3 = new StringBuffer();
            sbuf0.append('+');
            sbuf1.append('|');
            sbuf2.append('|');
            for (int i = 1; i < 70; ++i) {
                sbuf0.append('-');
                sbuf1.append('-');
                sbuf2.append('/');
                sbuf3.append(' ');
            }
            sbuf0.append('+');
            fixedline = sbuf0.toString().toCharArray();
            baseline = sbuf1.toString().toCharArray();
            barline = sbuf2.toString().toCharArray();
            spaces = sbuf3.toString().toCharArray();
        }
    }
}

