/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.vfs;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.jboss.virtual.plugins.vfs.VirtualFileURLConnection;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

public class VirtualFileUrlStreamHandler
extends URLStreamHandler {
    private final VFSContext context;

    public VirtualFileUrlStreamHandler(VirtualFileHandler handler) {
        this.context = handler.getVFSContext();
    }

    protected URLConnection openConnection(URL u) throws IOException {
        String baseRootUrl;
        try {
            baseRootUrl = this.context.getRoot().toVfsUrl().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String urlString = u.toString();
        int idx = urlString.indexOf(baseRootUrl);
        if (idx == -1) {
            throw new IOException(u.toString() + " does not belong to the same VFS context as " + baseRootUrl);
        }
        String path = urlString.substring(baseRootUrl.length());
        VirtualFileHandler vf = this.context.getRoot().findChild(path);
        if (vf == null) {
            throw new IOException(path + " was not found in VFS context " + baseRootUrl);
        }
        return new VirtualFileURLConnection(u, vf.getVirtualFile());
    }
}

