/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.sunday.unmarshalling.AttributesHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.xml.sax.Attributes;

public class DefaultElementHandler
implements ElementHandler,
ParticleHandler {
    private static final Logger log = Logger.getLogger(DefaultElementHandler.class);
    public static final DefaultElementHandler INSTANCE = new DefaultElementHandler();
    private AttributesHandler attrsHandler;

    public DefaultElementHandler() {
        this(AttributesHandler.INSTANCE);
    }

    public DefaultElementHandler(AttributesHandler attrsHandler) {
        this.attrsHandler = attrsHandler;
    }

    public Object startElement(Object parent, QName qName, ElementBinding element) {
        return parent;
    }

    public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
        if (this.attrsHandler != null) {
            this.attrsHandler.attributes(o, elementName, element.getType(), attrs, nsCtx);
        }
    }

    public Object endElement(Object o, QName qName, ElementBinding element) {
        return o;
    }

    public void setParent(Object parent, Object o, QName qName, ElementBinding element, ElementBinding parentElement) {
        if (log.isTraceEnabled()) {
            log.trace("Not setting " + o + " on " + parent + " for " + qName);
        }
    }

    public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx) {
        ElementBinding element = (ElementBinding)particle.getTerm();
        Object o = this.startElement(parent, elementName, element);
        if (o != null) {
            attrs = element.getType().expandWithDefaultAttributes(attrs);
            this.attributes(o, elementName, element, attrs, nsCtx);
        }
        return o;
    }

    public Object endParticle(Object o, QName elementName, ParticleBinding particle) {
        return this.endElement(o, elementName, (ElementBinding)particle.getTerm());
    }

    public void setParent(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle) {
        ElementBinding element = (ElementBinding)particle.getTerm();
        ElementBinding parentElement = (ElementBinding)parentParticle.getTerm();
        this.setParent(parent, o, elementName, element, parentElement);
    }
}

