/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
import org.jboss.xb.builder.runtime.ArrayWrapper;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapter;

public class PropertyInterceptor
extends DefaultElementInterceptor {
    private static final Logger log = Logger.getLogger(PropertyInterceptor.class);
    private boolean trace = log.isTraceEnabled();
    private PropertyInfo propertyInfo;
    private TypeInfo propertyType;

    public PropertyInterceptor(PropertyInfo propertyInfo, TypeInfo propertyType) {
        if (propertyInfo == null) {
            throw new IllegalArgumentException("Null property info");
        }
        if (propertyType == null) {
            throw new IllegalArgumentException("Null property type");
        }
        this.propertyInfo = propertyInfo;
        this.propertyType = propertyType;
    }

    public void add(Object parent, Object child, QName qName) {
        if (this.trace) {
            log.trace("setParent " + qName + " parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(child) + " property=" + this.propertyInfo.getName());
        }
        try {
            if (this.propertyType.isArray()) {
                ArrayWrapper wrapper = (ArrayWrapper)child;
                child = wrapper.getArray(this.propertyType);
            }
            BeanAdapter beanAdapter = (BeanAdapter)parent;
            beanAdapter.set(this.propertyInfo, child);
        }
        catch (Throwable t) {
            throw new RuntimeException("QName " + qName + " error setting property " + this.propertyInfo.getName() + " with value " + BuilderUtil.toDebugString(child) + " to " + BuilderUtil.toDebugString(parent), t);
        }
    }
}

