/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.tomcat;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.DeploymentGroup;

public class WebinfScanner
implements LifecycleListener {
    private DeploymentGroup group;
    private static Method basePathMethod;

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("start")) {
            String basePath;
            if (!(event.getSource() instanceof StandardContext)) {
                return;
            }
            StandardContext container = (StandardContext)event.getSource();
            container.getLoader().getClassLoader();
            Method getBasePath = WebinfScanner.getBasePathMethod();
            try {
                basePath = (String)getBasePath.invoke((Object)container, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            File webInf = new File(basePath, "WEB-INF");
            File webInfLib = new File(webInf, "lib");
            File webInfClasses = new File(webInf, "classes");
            this.group = Bootstrap.getInstance().createDeploymentGroup();
            try {
                if (webInfLib.exists()) {
                    this.group.add(webInfLib.toURL());
                }
                if (webInfClasses.exists()) {
                    this.group.add(webInfClasses.toURL());
                }
                for (DeploymentUnit deployment : this.group.getDeploymentUnits()) {
                    deployment.getTransientManagedObjects().addAttachment(StandardContext.class, (Object)container);
                }
                this.group.process();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (event.getType().equals("stop")) {
            try {
                this.group.undeploy();
            }
            catch (DeploymentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static synchronized Method getBasePathMethod() {
        if (basePathMethod != null) {
            return basePathMethod;
        }
        try {
            basePathMethod = StandardContext.class.getDeclaredMethod("getBasePath", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        basePathMethod.setAccessible(true);
        return basePathMethod;
    }
}

