/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynch;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.aop.Dispatcher;
import org.jboss.aspects.asynch.RemotableFuture;
import org.jboss.aspects.asynch.TimeoutException;
import org.jboss.util.id.GUID;

public class FutureImplJavaUtilConcurrent
implements RemotableFuture {
    private Future result;
    private GUID remoteObjectID;

    public FutureImplJavaUtilConcurrent(Future result) {
        this.result = result;
    }

    public void setRemoteObjectID(GUID remoteObjectID) {
        this.remoteObjectID = remoteObjectID;
    }

    public void release() {
        if (this.remoteObjectID != null) {
            Dispatcher.singleton.unregisterTarget(this.remoteObjectID);
        }
    }

    public Object get() throws InterruptedException, InvocationTargetException {
        try {
            Object rtn = this.result.get();
            this.release();
            return rtn;
        }
        catch (ExecutionException e) {
            this.release();
            throw new InvocationTargetException(e.getCause());
        }
    }

    public Object get(long milliseconds) throws TimeoutException, InterruptedException, InvocationTargetException {
        try {
            Object rtn = this.result.get(milliseconds, TimeUnit.MILLISECONDS);
            this.release();
            return rtn;
        }
        catch (ExecutionException e) {
            this.release();
            throw new InvocationTargetException(e.getCause());
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(e);
        }
    }

    public boolean isDone() {
        return this.result.isDone();
    }
}

