/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import org.jboss.beans.metadata.plugins.AbstractLifecycleMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.util.JBossStringBuilder;

public class AbstractInstallMetaData
extends AbstractLifecycleMetaData
implements InstallMetaData,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String bean;
    protected ControllerState dependentState = ControllerState.INSTALLED;

    public AbstractInstallMetaData() {
        this.setState(ControllerState.INSTALLED);
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public void setDependentState(ControllerState dependentState) {
        this.dependentState = dependentState;
        this.flushJBossObjectCache();
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public void initialVisit(MetaDataVisitor visitor) {
        KernelControllerContext context = visitor.getControllerContext();
        if (this.bean != null) {
            InstallationDependencyItem item = new InstallationDependencyItem(context.getName());
            visitor.addDependency(item);
        }
        super.initialVisit(visitor);
    }

    protected ClassInfo getClassInfo(KernelControllerContext context) throws Throwable {
        if (this.bean != null) {
            KernelController controller = (KernelController)context.getController();
            ControllerContext beanContext = controller.getContext(this.bean, ControllerState.INSTANTIATED);
            if (beanContext != null) {
                KernelConfigurator configurator = controller.getKernel().getConfigurator();
                Object target = beanContext.getTarget();
                return configurator.getClassInfo(target.getClass());
            }
            throw new IllegalArgumentException("Cannot determine install bean class: " + this);
        }
        return super.getClassInfo(context);
    }

    public void toString(JBossStringBuilder buffer) {
        if (this.bean != null) {
            buffer.append("bean=").append(this.bean);
        }
        if (!ControllerState.INSTALLED.equals(this.dependentState)) {
            buffer.append(" dependentState=" + this.dependentState);
        }
        buffer.append(" ");
        super.toString(buffer);
    }

    public void toShortString(JBossStringBuilder buffer) {
        if (this.bean != null) {
            buffer.append(this.bean).append(".");
        }
        if (this.methodName != null) {
            buffer.append(this.methodName);
        }
    }

    public class InstallationDependencyItem
    extends AbstractDependencyItem {
        public InstallationDependencyItem(Object name) {
            super(name, AbstractInstallMetaData.this.bean, AbstractInstallMetaData.this.state, AbstractInstallMetaData.this.dependentState);
        }
    }
}

