/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.util.Stack;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeMetaData
extends AbstractValueMetaData
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected String type;
    protected transient ControllerContext context;
    protected transient KernelConfigurator configurator;
    protected String propertyName;
    protected String beanName;

    public AbstractTypeMetaData() {
    }

    public AbstractTypeMetaData(String value) {
        super(value);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        this.context = visitor.getControllerContext();
        this.configurator = visitor.getControllerContext().getKernel().getConfigurator();
        this.preparePreinstantiatedLookup(visitor);
        visitor.initialVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preparePreinstantiatedLookup(MetaDataVisitor visitor) {
        Stack<MetaDataVisitorNode> visitorNodes = visitor.visitorNodeStack();
        MetaDataVisitorNode parent = visitorNodes.pop();
        try {
            PropertyMetaData pmd;
            if (parent instanceof PropertyMetaData && (pmd = (PropertyMetaData)parent).isPreInstantiate()) {
                this.propertyName = pmd.getName();
                MetaDataVisitorNode gp = visitorNodes.peek();
                if (gp instanceof BeanMetaData) {
                    BeanMetaData bmd = (BeanMetaData)gp;
                    this.beanName = bmd.getName();
                }
            }
        }
        finally {
            visitorNodes.push(parent);
        }
    }

    protected <T> T preinstantiatedLookup(ClassLoader cl, Class<T> expected) {
        if (this.propertyName != null && this.beanName != null) {
            Object result = null;
            try {
                Object target;
                Controller controller = this.context.getController();
                ControllerContext context = controller.getContext(this.beanName, ControllerState.INSTANTIATED);
                if (context != null && context instanceof AttributeDispatchContext && (target = context.getTarget()) != null) {
                    BeanInfo beanInfo = this.configurator.getBeanInfo(target.getClass());
                    PropertyInfo pi = Configurator.resolveProperty(this.log.isTraceEnabled(), beanInfo, cl, this.propertyName, null);
                    if (pi.getGetter() != null) {
                        result = ((AttributeDispatchContext)((Object)context)).get(this.propertyName);
                    }
                }
            }
            catch (Throwable t) {
                this.log.warn("Exception in preinstantiated lookup for: " + this.beanName + "." + this.propertyName + ", " + t);
            }
            return this.checkResult(result, expected);
        }
        return null;
    }

    protected <T> T checkResult(Object result, Class<T> expected) {
        if (result != null && !expected.isAssignableFrom(result.getClass())) {
            throw new ClassCastException(result.getClass() + " is not a " + expected.getName());
        }
        return expected.cast(result);
    }

    protected <T> T createInstance(TypeInfo info, ClassLoader cl, Class<T> expected, boolean explicit) throws Throwable {
        if (info == null || Object.class.getName().equals(info.getName())) {
            return null;
        }
        if (!(info instanceof ClassInfo)) {
            if (explicit) {
                throw new IllegalArgumentException(info.getName() + " is not a class");
            }
            return null;
        }
        if (((ClassInfo)info).isInterface()) {
            if (explicit) {
                throw new IllegalArgumentException(info.getName() + " is an interface");
            }
            return null;
        }
        BeanInfo beanInfo = this.configurator.getBeanInfo(info);
        Joinpoint constructor = this.configurator.getConstructorJoinPoint(beanInfo);
        Object result = constructor.dispatch();
        if (!expected.isAssignableFrom(result.getClass())) {
            throw new ClassCastException(result.getClass() + " is not a " + expected.getName());
        }
        return expected.cast(result);
    }

    protected <T> T getTypeInstance(TypeInfo info, ClassLoader cl, Class<T> expected) throws Throwable {
        T result = null;
        ClassInfo typeInfo = this.getClassInfo(cl);
        if (typeInfo != null) {
            result = this.createInstance(typeInfo, cl, expected, true);
        }
        if (result == null && (result = (T)this.preinstantiatedLookup(cl, expected)) == null && (result = (T)this.createInstance(info, cl, expected, false)) == null) {
            result = expected.cast(this.getDefaultInstance());
        }
        return result;
    }

    protected abstract Object getDefaultInstance();

    public void setConfigurator(KernelConfigurator configurator) {
        this.configurator = configurator;
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        if (this.type != null) {
            buffer.append(" type=").append(this.type);
        }
    }

    protected ClassInfo getClassInfo(ClassLoader cl) throws Throwable {
        return this.getClassInfo(this.type, cl);
    }

    protected ClassInfo getClassInfo(String classType, ClassLoader cl) throws Throwable {
        if (classType == null) {
            return null;
        }
        return this.configurator.getClassInfo(classType, cl);
    }

    protected ClassInfo getClass(MetaDataVisitor visitor, String classType) throws Throwable {
        KernelControllerContext context = visitor.getControllerContext();
        ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
        return this.getClassInfo(classType, cl);
    }
}

