/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class InjectionOption
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final InjectionOption STRICT = new InjectionOption("Strict");
    public static final InjectionOption CALLBACK = new InjectionOption("Callback");
    protected final String optionString;

    private InjectionOption(String optionString) {
        if (optionString == null) {
            throw new IllegalArgumentException("Null option string");
        }
        this.optionString = optionString;
    }

    public static InjectionOption getInstance(String optionString) {
        if (STRICT.getOptionString().equalsIgnoreCase(optionString)) {
            return STRICT;
        }
        if (CALLBACK.getOptionString().equalsIgnoreCase(optionString)) {
            return CALLBACK;
        }
        throw new IllegalArgumentException("No such option: " + optionString);
    }

    public String getOptionString() {
        return this.optionString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof InjectionOption)) {
            return false;
        }
        InjectionOption other = (InjectionOption)object;
        return this.optionString.equals(other.getOptionString());
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append(this.optionString);
    }

    protected int getHashCode() {
        return this.optionString.hashCode();
    }
}

