/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.classloading.helpers;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.classloading.PackageCapability;
import org.jboss.deployers.structure.spi.classloading.RequirePackage;
import org.jboss.deployers.structure.spi.classloading.Requirement;
import org.jboss.deployers.structure.spi.classloading.Version;

public class PackageCapabilityImpl
implements PackageCapability {
    private static final long serialVersionUID = -1586959469453286396L;
    private String name;
    private Version version;

    public PackageCapabilityImpl(String name) {
        this(name, null);
    }

    public PackageCapabilityImpl(String name, Version version) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (version == null) {
            version = Version.DEFAULT_VERSION;
        }
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean resolves(DeploymentUnit unit, Requirement requirement) {
        if (!(requirement instanceof RequirePackage)) {
            return false;
        }
        RequirePackage requirePackage = (RequirePackage)requirement;
        if (!this.getName().equals(requirePackage.getName())) {
            return false;
        }
        return requirePackage.getVersionRange().isInRange(this.getVersion());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PackageCapability)) {
            return false;
        }
        PackageCapability other = (PackageCapability)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return this.getVersion().equals(other.getVersion());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "Package: " + this.getName() + ":" + this.getVersion();
    }
}

