/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import java.net.URL;
import java.util.Set;
import org.jboss.deployers.plugins.classloading.AbstractTopLevelClassLoaderSystemDeployer;
import org.jboss.deployers.plugins.classloading.Module;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.vfs.plugins.classloader.VFSClassLoaderPolicy;
import org.jboss.deployers.vfs.spi.structure.helpers.ClassPathVisitor;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.memory.MemoryContextFactory;

public class VFSTopLevelClassLoaderSystemDeployer
extends AbstractTopLevelClassLoaderSystemDeployer {
    protected VFSClassLoaderPolicy createTopLevelClassLoaderPolicy(DeploymentContext context, Module module) throws Exception {
        ClassPathVisitor visitor = new ClassPathVisitor();
        context.visit(visitor);
        Set<VirtualFile> classPath = visitor.getClassPath();
        VirtualFile[] roots = new VirtualFile[classPath.size() + 1];
        int i = 0;
        for (VirtualFile path : classPath) {
            roots[i++] = path;
        }
        MemoryContextFactory factory = MemoryContextFactory.getInstance();
        factory.createRoot(module.getDynamicClassRoot());
        URL url = new URL(module.getDynamicClassRoot() + "/classes");
        roots[i++] = factory.createDirectory(url).getVirtualFile();
        VFSClassLoaderPolicy policy = new VFSClassLoaderPolicy(roots);
        policy.setExportAll(module.getExportAll());
        policy.setImportAll(module.isImportAll());
        return policy;
    }

    protected void cleanup(DeploymentContext context, Module module) throws Exception {
        MemoryContextFactory factory = MemoryContextFactory.getInstance();
        factory.deleteRoot(module.getDynamicClassRoot());
    }
}

