/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedClassFilter
implements VirtualFileVisitor {
    private static Logger log = Logger.getLogger(AnnotatedClassFilter.class);
    private ClassLoader loader;
    private VirtualFile classpathRoot;
    private int rootLength;
    private HashSet<String> childPaths = new HashSet();
    private HashMap<VirtualFile, Class<?>> pathToClasses = new HashMap();

    public AnnotatedClassFilter(VFSDeploymentUnit unit, ClassLoader loader, VirtualFile classpathRoot) {
        List<DeploymentUnit> children;
        this.loader = loader;
        this.classpathRoot = classpathRoot;
        String rootName = classpathRoot.getPathName();
        this.rootLength = rootName.length();
        if (this.rootLength > 0) {
            ++this.rootLength;
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit cu : children) {
                String path = cu.getName();
                this.childPaths.add(path);
            }
        }
    }

    public Map<VirtualFile, Class<?>> getAnnotatedClasses() {
        return this.pathToClasses;
    }

    @Override
    public VisitorAttributes getAttributes() {
        VisitorAttributes attributes = new VisitorAttributes();
        attributes.setIncludeRoot(true);
        attributes.setRecurseFilter(new NoChildFilter());
        return attributes;
    }

    @Override
    public void visit(VirtualFile file) {
        try {
            if (file.isLeaf()) {
                this.accepts(file);
            }
        }
        catch (IOException e) {
            throw new Error("Error visiting " + file, e);
        }
    }

    public boolean accepts(VirtualFile file) {
        boolean accepts;
        block5: {
            accepts = file.getPathName().endsWith(".class");
            if (accepts) {
                accepts = false;
                String className = null;
                try {
                    className = this.getClassName(file);
                    Class<?> c = this.loader.loadClass(className);
                    Annotation[] annotations = c.getAnnotations();
                    if (annotations != null && annotations.length > 0) {
                        this.pathToClasses.put(file, c);
                        accepts = true;
                    }
                }
                catch (NoClassDefFoundError ignored) {
                    log.debug("Incomplete class: " + className + ", NCDFE: " + ignored);
                }
                catch (Exception ignored) {
                    if (!log.isTraceEnabled()) break block5;
                    log.trace("Failed to load class: " + className, ignored);
                }
            }
        }
        return accepts;
    }

    protected String getFilePath(VirtualFile file) {
        String path = null;
        try {
            path = file.toURI().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    protected String getClassName(VirtualFile classFile) throws IOException {
        String pathName = classFile.getPathName();
        String name = pathName.substring(this.rootLength, pathName.length() - 6);
        name = name.replace('/', '.');
        return name;
    }

    class NoChildFilter
    implements VirtualFileFilter {
        NoChildFilter() {
        }

        public boolean accepts(VirtualFile file) {
            String path = AnnotatedClassFilter.this.getFilePath(file);
            boolean accepts = false;
            try {
                accepts = !file.isLeaf() && !AnnotatedClassFilter.this.childPaths.contains(path);
            }
            catch (Exception e) {
                // empty catch block
            }
            return accepts;
        }
    }
}

