/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.security.auth.Subject;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SecurityUtil;
import org.jboss.security.integration.ejb.EJBAuthenticationHelper;
import org.jboss.security.integration.ejb.EJBAuthorizationHelper;
import org.jboss.system.Registry;

public class SecurityInterceptor
extends AbstractInterceptor {
    protected AuthenticationManager securityManager;
    protected RealmMapping realmMapping;
    protected RunAs runAsIdentity;
    protected Map securityRoles;
    protected Map deploymentRoles;
    protected AuthenticationObserver authenticationObserver;
    protected Method ejbTimeout;
    protected String ejbName = null;
    protected CodeSource ejbCS = null;
    protected String appSecurityDomain = null;
    protected String defaultAuthorizationSecurityDomain = "jboss-ejb-policy";
    protected boolean isUseCallerIdentity = false;
    protected ISecurityManagement securityManagement = null;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            ApplicationMetaData applicationMetaData = beanMetaData.getApplicationMetaData();
            AssemblyDescriptorMetaData assemblyDescriptor = applicationMetaData.getAssemblyDescriptor();
            this.securityRoles = assemblyDescriptor.getSecurityRoles();
            this.deploymentRoles = assemblyDescriptor.getPrincipalVersusRolesMap();
            SecurityIdentityMetaData secMetaData = beanMetaData.getSecurityIdentityMetaData();
            if (secMetaData != null && !secMetaData.getUseCallerIdentity()) {
                String roleName = secMetaData.getRunAsRoleName();
                String principalName = secMetaData.getRunAsPrincipalName();
                if (principalName == null) {
                    principalName = applicationMetaData.getUnauthenticatedPrincipal();
                }
                Set<String> extraRoleNames = assemblyDescriptor.getSecurityRoleNamesByPrincipal(principalName);
                this.runAsIdentity = new RunAsIdentity(roleName, principalName, extraRoleNames);
            }
            if (secMetaData != null && secMetaData.getUseCallerIdentity()) {
                this.isUseCallerIdentity = true;
            }
            this.securityManager = container.getSecurityManager();
            this.realmMapping = container.getRealmMapping();
            try {
                this.ejbTimeout = TimedObject.class.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            if (this.securityManager != null) {
                this.appSecurityDomain = this.securityManager.getSecurityDomain();
                this.appSecurityDomain = SecurityUtil.unprefixSecurityDomain(this.appSecurityDomain);
            }
            this.ejbName = beanMetaData.getEjbName();
            this.ejbCS = container.getBeanClass().getProtectionDomain().getCodeSource();
            this.securityManagement = container.getSecurityManagement();
        }
    }

    public void start() throws Exception {
        super.start();
        this.authenticationObserver = (AuthenticationObserver)Registry.lookup("SecurityInterceptor.AuthenticationObserver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        Object object;
        if (this.shouldBypassSecurity(mi)) {
            return this.getNext().invokeHome(mi);
        }
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc == null) {
            throw new IllegalStateException("Security Context is null");
        }
        RunAs callerRunAsIdentity = sc.getIncomingRunAs();
        this.checkSecurityContext(mi, callerRunAsIdentity);
        if (callerRunAsIdentity != null && this.isUseCallerIdentity) {
            this.runAsIdentity = callerRunAsIdentity;
        }
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            object = returnValue = this.getNext().invokeHome(mi);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SecurityActions.popRunAsIdentity();
            SecurityActions.popSubjectContext();
            throw throwable;
        }
        SecurityActions.popRunAsIdentity();
        SecurityActions.popSubjectContext();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation mi) throws Exception {
        Object object;
        if (this.shouldBypassSecurity(mi)) {
            return this.getNext().invoke(mi);
        }
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc == null) {
            throw new IllegalStateException("Security Context is null");
        }
        RunAs callerRunAsIdentity = sc.getIncomingRunAs();
        this.checkSecurityContext(mi, callerRunAsIdentity);
        if (callerRunAsIdentity != null && this.isUseCallerIdentity) {
            this.runAsIdentity = callerRunAsIdentity;
        }
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            object = returnValue = this.getNext().invoke(mi);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SecurityActions.popRunAsIdentity();
            SecurityActions.popSubjectContext();
            throw throwable;
        }
        SecurityActions.popRunAsIdentity();
        SecurityActions.popSubjectContext();
        return object;
    }

    private void checkSecurityContext(Invocation mi, RunAs callerRunAsIdentity) throws Exception {
        boolean containerMethod;
        Principal principal = mi.getPrincipal();
        Object credential = mi.getCredential();
        boolean trace = this.log.isTraceEnabled();
        Method m = mi.getMethod();
        boolean bl = containerMethod = m == null || m.equals(this.ejbTimeout);
        if (containerMethod || this.securityManager == null || this.container == null) {
            SecurityActions.pushSubjectContext(principal, credential, null);
            return;
        }
        if (this.realmMapping == null) {
            throw new SecurityException("Role mapping manager has not been set");
        }
        SecurityContext sc = SecurityActions.getSecurityContext();
        EJBAuthenticationHelper helper = new EJBAuthenticationHelper(sc);
        boolean isTrusted = helper.isTrusted();
        if (!isTrusted) {
            Subject subject = new Subject();
            if (!helper.isValid(subject, m.getName())) {
                if (this.authenticationObserver != null) {
                    this.authenticationObserver.authenticationFailed();
                }
                String msg = "Authentication exception, principal=" + principal;
                throw new SecurityException(msg);
            }
            SecurityActions.pushSubjectContext(principal, credential, subject);
            if (trace) {
                this.log.trace("Authenticated  principal=" + principal);
            }
        } else {
            SecurityActions.pushRunAsIdentity(callerRunAsIdentity);
        }
        Method ejbMethod = mi.getMethod();
        if (ejbMethod == null) {
            return;
        }
        Subject caller = SecurityActions.getContextSubject();
        if (caller == null) {
            throw new IllegalStateException("Authenticated User. But caller subject is null");
        }
        SecurityRolesAssociation.setSecurityRoles(this.deploymentRoles);
        boolean isAuthorized = false;
        Set<Principal> methodRoles = this.container.getMethodPermissions(ejbMethod, mi.getType());
        SecurityContext currentSC = SecurityActions.getSecurityContext();
        if (currentSC.getSecurityManagement() == null) {
            currentSC.setSecurityManagement(this.securityManagement);
        }
        EJBAuthorizationHelper eah = new EJBAuthorizationHelper(currentSC);
        isAuthorized = eah.authorize(this.ejbName, ejbMethod, mi.getPrincipal(), mi.getType().toInterfaceString(), this.ejbCS, caller, callerRunAsIdentity, methodRoles);
        String msg = "Denied: caller with subject=" + caller + " and security context post-mapping roles=" + currentSC.getUtil().getRoles();
        if (!isAuthorized) {
            throw new SecurityException(msg);
        }
    }

    private boolean shouldBypassSecurity(Invocation mi) throws Exception {
        boolean containerMethod;
        Method m = mi.getMethod();
        boolean bl = containerMethod = m == null || m.equals(this.ejbTimeout);
        if (containerMethod || this.securityManager == null || this.container == null) {
            SecurityActions.createAndSetSecurityContext(mi.getPrincipal(), mi.getCredential(), "BYPASSED-SECURITY");
            if (this.runAsIdentity != null) {
                SecurityActions.pushRunAsIdentity(this.runAsIdentity);
            }
            return true;
        }
        return false;
    }

    public static interface AuthenticationObserver {
        public static final String KEY = "SecurityInterceptor.AuthenticationObserver";

        public void authenticationFailed();
    }
}

