/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.HashMap;
import java.util.HashSet;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.logging.Logger;
import org.jboss.security.RealmMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseContext<T extends Container>
implements BeanContext<T> {
    protected static Logger log = Logger.getLogger(BaseContext.class);
    protected T container;
    protected Object bean;
    protected RealmMapping rm;
    protected SimpleMetaData metadata;
    protected HashMap<Class, Object> interceptorInstances;

    protected BaseContext(T container) {
        assert (container != null) : "container is null";
        this.container = container;
    }

    protected BaseContext(T container, Object bean) {
        this(container);
        assert (bean != null) : "bean is null";
        this.bean = bean;
    }

    public Object getId() {
        return null;
    }

    @Override
    public Object getInstance() {
        return this.bean;
    }

    @Override
    public T getContainer() {
        return this.container;
    }

    @Override
    public SimpleMetaData getMetaData() {
        if (this.metadata == null) {
            this.metadata = new SimpleMetaData();
        }
        return this.metadata;
    }

    @Override
    public void initialiseInterceptorInstances() {
        HashSet<InterceptorInfo> interceptors = ((EJBContainer)this.container).getApplicableInterceptors();
        if (interceptors != null && interceptors.size() > 0 && this.interceptorInstances == null) {
            HashMap<Class, InterceptorInjector> interceptorInjectors = ((EJBContainer)this.container).getInterceptorInjectors();
            this.interceptorInstances = new HashMap();
            for (InterceptorInfo info : interceptors) {
                try {
                    Object instance = info.getClazz().newInstance();
                    this.interceptorInstances.put(info.getClazz(), instance);
                    interceptorInjectors.get(info.getClazz()).inject(this, instance);
                }
                catch (Exception e) {
                    log.warn("Interceptors must have a public noargs constructor: " + info.getClazz().getName());
                }
            }
        }
    }

    @Override
    public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos) {
        Object[] interceptors = new Object[interceptorInfos.length];
        int i = 0;
        for (InterceptorInfo info : interceptorInfos) {
            interceptors[i++] = this.interceptorInstances.get(info.getClazz());
        }
        return interceptors;
    }

    public Object getInvokedMethodKey() {
        return this.container;
    }
}

