/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.connectionfactory;

import java.util.Map;
import javax.management.ObjectName;
import org.jboss.jms.client.plugin.LoadBalancingFactory;
import org.jboss.jms.server.ConnectionFactoryManager;
import org.jboss.jms.server.ConnectionManager;
import org.jboss.jms.server.ConnectorManager;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.connectionfactory.JNDIBindings;
import org.jboss.messaging.util.ExceptionUtil;
import org.jboss.messaging.util.JMXAccessor;
import org.jboss.remoting.InvokerLocator;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public class ConnectionFactory
extends ServiceMBeanSupport {
    private String clientID;
    private JNDIBindings jndiBindings;
    private int prefetchSize = 150;
    private boolean slowConsumers;
    private boolean supportsFailover;
    private boolean supportsLoadBalancing;
    private LoadBalancingFactory loadBalancingFactory;
    private int defaultTempQueueFullSize = 200000;
    private int defaultTempQueuePageSize = 2000;
    private int defaultTempQueueDownCacheSize = 2000;
    private int dupsOKBatchSize = 1000;
    private ObjectName serverPeerObjectName;
    private ConnectionFactoryManager connectionFactoryManager;
    private ConnectorManager connectorManager;
    private ConnectionManager connectionManager;
    private ObjectName connectorObjectName;
    private boolean started;
    private boolean strictTck;
    private boolean disableRemotingChecks;

    public ConnectionFactory() {
        this((String)null);
    }

    public ConnectionFactory(String clientID) {
        this.clientID = clientID;
        this.loadBalancingFactory = LoadBalancingFactory.getDefaultFactory();
    }

    public synchronized void startService() throws Exception {
        try {
            boolean enablePing;
            this.log.debug(this + " starting");
            this.started = true;
            if (this.connectorObjectName == null) {
                throw new IllegalArgumentException("A Connector must be specified for each Connection Factory");
            }
            if (this.serverPeerObjectName == null) {
                throw new IllegalArgumentException("ServerPeer must be specified for each Connection Factory");
            }
            String locatorURI = (String)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.connectorObjectName, "InvokerLocator");
            ServerPeer serverPeer = (ServerPeer)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.serverPeerObjectName, "Instance");
            if (!serverPeer.isSupportsFailover()) {
                this.supportsFailover = false;
            }
            InvokerLocator locator = new InvokerLocator(locatorURI);
            String protocol = locator.getProtocol();
            if (!this.disableRemotingChecks && (protocol.equals("bisocket") || protocol.equals("sslbisocket"))) {
                int i;
                boolean cont;
                Map params = locator.getParameters();
                boolean bl = cont = this.checkParam(params, "marshaller", "org.jboss.jms.wireformat.JMSWireFormat") && this.checkParam(params, "unmarshaller", "org.jboss.jms.wireformat.JMSWireFormat") && this.checkParam(params, "dataType", "jms") && this.checkParam(params, "timeout", "0") && this.checkParam(params, "clientSocketClass", "org.jboss.jms.client.remoting.ClientSocketWrapper") && this.checkParam(params, "numberOfCallRetries", "1") && this.checkParam(params, "pingFrequency", "214748364") && this.checkParam(params, "pingWindowFactor", "10");
                if (!cont) {
                    throw new IllegalArgumentException("Failed to deploy connection factory since remoting configuration seems incorrect.");
                }
                String val = (String)params.get("clientLeasePeriod");
                if (val != null && (i = Integer.parseInt(val)) < 5000) {
                    this.log.warn("Value of clientLeasePeriod at " + i + " seems low. Normal values are >= 5000");
                }
                if ((val = (String)params.get("clientMaxPoolSize")) != null && (i = Integer.parseInt(val)) < 50) {
                    this.log.warn("Value of clientMaxPoolSize at " + i + " seems low. Normal values are >= 50");
                }
            }
            this.connectionFactoryManager = serverPeer.getConnectionFactoryManager();
            this.connectorManager = serverPeer.getConnectorManager();
            this.connectionManager = serverPeer.getConnectionManager();
            int refCount = this.connectorManager.registerConnector(this.connectorObjectName.getCanonicalName());
            long leasePeriod = (Long)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.connectorObjectName, "LeasePeriod");
            boolean bl = enablePing = leasePeriod > 0L;
            if (refCount == 1 && enablePing) {
                this.server.invoke(this.connectorObjectName, "addConnectionListener", new Object[]{this.connectionManager}, new String[]{"org.jboss.remoting.ConnectionListener"});
            }
            this.connectionFactoryManager.registerConnectionFactory(this.getServiceName().getCanonicalName(), this.clientID, this.jndiBindings, locatorURI, enablePing, this.prefetchSize, this.slowConsumers, this.defaultTempQueueFullSize, this.defaultTempQueuePageSize, this.defaultTempQueueDownCacheSize, this.dupsOKBatchSize, this.supportsFailover, this.supportsLoadBalancing, this.loadBalancingFactory, this.strictTck);
            String info = "Connector " + locator.getProtocol() + "://" + locator.getHost() + ":" + locator.getPort();
            info = enablePing ? info + " has leasing enabled, lease period " + leasePeriod + " milliseconds" : info + " has lease disabled";
            this.log.info(info);
            this.log.info(this + " started");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    public synchronized void stopService() throws Exception {
        try {
            this.started = false;
            this.connectionFactoryManager.unregisterConnectionFactory(this.getServiceName().getCanonicalName(), this.supportsFailover, this.supportsLoadBalancing);
            this.connectorManager.unregisterConnector(this.connectorObjectName.getCanonicalName());
            this.log.info(this + " undeployed");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    public int getDefaultTempQueueFullSize() {
        return this.defaultTempQueueFullSize;
    }

    public void setDefaultTempQueueFullSize(int size) {
        this.defaultTempQueueFullSize = size;
    }

    public int getDefaultTempQueuePageSize() {
        return this.defaultTempQueuePageSize;
    }

    public void setDefaultTempQueuePageSize(int size) {
        this.defaultTempQueuePageSize = size;
    }

    public int getDefaultTempQueueDownCacheSize() {
        return this.defaultTempQueueDownCacheSize;
    }

    public void setDefaultTempQueueDownCacheSize(int size) {
        this.defaultTempQueueDownCacheSize = size;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public boolean isSlowConsumers() {
        return this.slowConsumers;
    }

    public void setSlowConsumers(boolean slowConsumers) {
        this.slowConsumers = slowConsumers;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setJNDIBindings(Element e) throws Exception {
        this.jndiBindings = new JNDIBindings(e);
    }

    public Element getJNDIBindings() {
        if (this.jndiBindings == null) {
            return null;
        }
        return this.jndiBindings.getDelegate();
    }

    public void setServerPeer(ObjectName on) {
        if (this.started) {
            this.log.warn("Cannot change the value of associated server ObjectName after initialization!");
            return;
        }
        this.serverPeerObjectName = on;
    }

    public ObjectName getServerPeer() {
        return this.serverPeerObjectName;
    }

    public void setConnector(ObjectName on) {
        if (this.started) {
            this.log.warn("Cannot change the value of associated connector ObjectName after initialization!");
            return;
        }
        this.connectorObjectName = on;
    }

    public ObjectName getConnector() {
        return this.connectorObjectName;
    }

    public boolean isSupportsFailover() {
        return this.supportsFailover;
    }

    public void setSupportsFailover(boolean supportsFailover) {
        if (this.started) {
            this.log.warn("supportsFailover can only be changed when connection factory is stopped");
            return;
        }
        this.supportsFailover = supportsFailover;
    }

    public boolean isSupportsLoadBalancing() {
        return this.supportsLoadBalancing;
    }

    public void setSupportsLoadBalancing(boolean supportsLoadBalancing) {
        if (this.started) {
            this.log.warn("supportsLoadBalancing can only be changed when connection factory is stopped");
            return;
        }
        this.supportsLoadBalancing = supportsLoadBalancing;
    }

    public String getLoadBalancingFactory() {
        return this.loadBalancingFactory.getClass().getName();
    }

    public void setLoadBalancingFactory(String factoryName) throws Exception {
        if (this.started) {
            this.log.warn("Load balancing policy can only be changed when connection factory is stopped");
            return;
        }
        Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(factoryName);
        this.loadBalancingFactory = (LoadBalancingFactory)clz.newInstance();
    }

    public void setDupsOKBatchSize(int size) throws Exception {
        if (this.started) {
            this.log.warn("DupsOKBatchSize can only be changed when connection factory is stopped");
            return;
        }
        this.dupsOKBatchSize = size;
    }

    public int getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    public boolean isStrictTck() {
        return this.strictTck;
    }

    public void setStrictTck(boolean strictTck) {
        if (this.started) {
            this.log.warn("StrictTCK can only be changed when connection factory is stopped");
            return;
        }
        this.strictTck = strictTck;
    }

    public boolean isDisableRemotingChecks() {
        return this.disableRemotingChecks;
    }

    public void setDisableRemotingChecks(boolean disable) {
        if (this.started) {
            this.log.warn("DisableRemotingChecks can only be changed when connection factory is stopped");
            return;
        }
        this.disableRemotingChecks = disable;
    }

    private boolean checkParam(Map params, String key, String value) {
        String val = (String)params.get(key);
        if (val == null) {
            this.log.error("Parameter " + key + " is not specified in the remoting congiguration");
            return false;
        }
        if (!val.equals(value)) {
            this.log.error("Parameter " + key + " has a different value ( " + val + ") to the default shipped with this version of " + "JBM (" + value + "). " + "There is rarely a valid reason to change this parameter value. " + "If you are using ServiceBindingManager to supply the remoting configuration you should check " + "that the parameter value specified there exactly matches the value in the configuration supplied with JBM. " + "This connection factory will now not deploy. To override these checks set 'disableRemotingChecks' to " + "true on the connection factory. Only do this if you are absolutely sure you know the consequences.");
            return false;
        }
        return true;
    }
}

