/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.Iterator;
import java.util.Stack;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetaDataVisitor
implements MetaDataVisitor {
    private static final Logger log = Logger.getLogger(AbstractMetaDataVisitor.class);
    protected ControllerState contextState = ControllerState.INSTANTIATED;
    protected BeanMetaData bmd;
    protected KernelControllerContext context;
    protected Stack<MetaDataVisitorNode> visitorNodeStack;

    protected AbstractMetaDataVisitor(BeanMetaData bmd, KernelControllerContext context) {
        this.bmd = bmd;
        this.context = context;
        this.visitorNodeStack = new Stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialVisit(MetaDataVisitorNode node) {
        this.visitorNodeStack.push(node);
        try {
            this.internalInitialVisit(node);
        }
        finally {
            this.visitorNodeStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void describeVisit(MetaDataVisitorNode node) {
        this.visitorNodeStack.push(node);
        try {
            this.internalDescribeVisit(node);
        }
        finally {
            this.visitorNodeStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalInitialVisit(MetaDataVisitorNode node) {
        Iterator<? extends MetaDataVisitorNode> children;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Initial visit node " + node);
        }
        if ((children = node.getChildren()) != null) {
            ControllerState restoreState = this.contextState;
            while (children.hasNext()) {
                MetaDataVisitorNode child = children.next();
                try {
                    child.initialVisit(this);
                }
                finally {
                    this.contextState = restoreState;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalDescribeVisit(MetaDataVisitorNode node) {
        Iterator<? extends MetaDataVisitorNode> children;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Describe visit node " + node);
        }
        if ((children = node.getChildren()) != null) {
            ControllerState restoreState = this.contextState;
            while (children.hasNext()) {
                MetaDataVisitorNode child = children.next();
                try {
                    child.describeVisit(this);
                }
                finally {
                    this.contextState = restoreState;
                }
            }
        }
    }

    @Override
    public KernelControllerContext getControllerContext() {
        return this.context;
    }

    @Override
    public ControllerState getContextState() {
        return this.contextState;
    }

    public DependencyInfo getDependencyInfo() {
        return this.context.getDependencyInfo();
    }

    @Override
    public void addDependency(DependencyItem dependency) {
        this.getDependencyInfo().addIDependOn(dependency);
    }

    @Override
    public <T> void addInstallCallback(CallbackItem<T> callback) {
        this.getDependencyInfo().addInstallItem(callback);
    }

    @Override
    public <T> void addUninstallCallback(CallbackItem<T> callback) {
        this.getDependencyInfo().addUninstallItem(callback);
    }

    @Override
    public void setContextState(ControllerState contextState) {
        this.contextState = contextState;
    }

    @Override
    public Stack<MetaDataVisitorNode> visitorNodeStack() {
        return this.visitorNodeStack;
    }
}

