/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.server.BasicQueueParameters;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.MessageCounter;
import org.jboss.mq.server.MessageReference;

public abstract class JMSDestination {
    SpyDestination destination;
    ClientConsumer temporaryDestination;
    JMSDestinationManager server;
    long nextMessageIdCounter = 0L;
    Object nextMessageIdLock = new Object();
    static long nextSharedMessageIdCounter = 0L;
    static Object nextSharedMessageIdLock = new Object();
    public BasicQueueParameters parameters;
    static Logger cat = Logger.getLogger(JMSDestination.class);

    JMSDestination(SpyDestination dest, ClientConsumer temporary, JMSDestinationManager server, BasicQueueParameters parameters) throws JMSException {
        this.destination = dest;
        this.temporaryDestination = temporary;
        this.server = server;
        this.parameters = parameters;
    }

    public SpyDestination getSpyDestination() {
        return this.destination;
    }

    public abstract void addSubscriber(Subscription var1) throws JMSException;

    public abstract void removeSubscriber(Subscription var1) throws JMSException;

    public abstract void nackMessages(Subscription var1) throws JMSException;

    public abstract SpyMessage receive(Subscription var1, boolean var2) throws JMSException;

    public abstract void addReceiver(Subscription var1) throws JMSException;

    public abstract void removeReceiver(Subscription var1);

    public abstract void restoreMessage(MessageReference var1);

    public void restoreMessage(SpyMessage message) {
        this.restoreMessage(message, null, 0);
    }

    public abstract void restoreMessage(SpyMessage var1, Tx var2, int var3);

    public abstract boolean isInUse();

    public abstract void close() throws JMSException;

    public abstract void removeAllMessages() throws JMSException;

    public abstract void acknowledge(AcknowledgementRequest var1, Subscription var2, Tx var3) throws JMSException;

    public abstract void addMessage(SpyMessage var1, Tx var2) throws JMSException;

    public abstract MessageCounter[] getMessageCounter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long nextSharedMessageId() {
        Object object = nextSharedMessageIdLock;
        synchronized (object) {
            return nextSharedMessageIdCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateSharedNextMessageId(SpyMessage message) {
        Object object = nextSharedMessageIdLock;
        synchronized (object) {
            nextSharedMessageIdCounter = Math.max(nextSharedMessageIdCounter, message.header.messageId + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long nextMessageId() {
        if (this.parameters.lateClone) {
            return JMSDestination.nextSharedMessageId();
        }
        Object object = this.nextMessageIdLock;
        synchronized (object) {
            return this.nextMessageIdCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNextMessageId(SpyMessage message) {
        if (this.parameters.lateClone) {
            JMSDestination.updateSharedNextMessageId(message);
            return;
        }
        Object object = this.nextMessageIdLock;
        synchronized (object) {
            this.nextMessageIdCounter = Math.max(this.nextMessageIdCounter, message.header.messageId + 1L);
        }
    }
}

