/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.sm.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.sm.AbstractStateManager;
import org.jboss.mq.sm.StateManager;
import org.jboss.mq.sm.jdbc.JDBCStateManagerMBean;
import org.jboss.tm.TransactionManagerLocator;

public class JDBCStateManager
extends AbstractStateManager
implements JDBCStateManagerMBean {
    static final Logger log = Logger.getLogger(JDBCStateManager.class);
    private ObjectName connectionManagerName;
    protected DataSource dataSource;
    protected int connectionRetryAttempts = 5;
    private boolean hasSecurityManager = true;
    protected TransactionManager tm;
    protected Properties sqlProperties = new Properties();
    protected boolean createTables = true;
    protected String CREATE_USER_TABLE = "CREATE TABLE JMS_USERS (USERID VARCHAR(32) NOT NULL, PASSWD VARCHAR(32) NOT NULL, CLIENTID VARCHAR(128), PRIMARY KEY(USERID))";
    protected String CREATE_ROLE_TABLE = "CREATE TABLE JMS_ROLES (ROLEID VARCHAR(32) NOT NULL, USERID VARCHAR(32) NOT NULL, PRIMARY KEY(USERID, ROLEID))";
    protected String CREATE_SUBSCRIPTION_TABLE = "CREATE TABLE JMS_SUBSCRIPTIONS (CLIENTID VARCHAR(128) NOT NULL, NAME VARCHAR(128) NOT NULL, TOPIC VARCHAR(255) NOT NULL, SELECTOR VARCHAR(255), PRIMARY KEY(CLIENTID, NAME))";
    protected String GET_SUBSCRIPTION = "SELECT TOPIC, SELECTOR FROM JMS_SUBSCRIPTIONS WHERE CLIENTID=? AND NAME=?";
    protected String GET_SUBSCRIPTIONS_FOR_TOPIC = "SELECT CLIENTID, NAME, SELECTOR FROM JMS_SUBSCRIPTIONS WHERE TOPIC=?";
    protected String LOCK_SUBSCRIPTION = "SELECT TOPIC, SELECTOR FROM JMS_SUBSCRIPTIONS WHERE CLIENTID=? AND NAME=?";
    protected String INSERT_SUBSCRIPTION = "INSERT INTO JMS_SUBSCRIPTIONS (CLIENTID, NAME, TOPIC, SELECTOR) VALUES(?,?,?,?)";
    protected String UPDATE_SUBSCRIPTION = "UPDATE JMS_SUBSCRIPTIONS SET TOPIC=?, SELECTOR=? WHERE CLIENTID=? AND NAME=?";
    protected String REMOVE_SUBSCRIPTION = "DELETE FROM JMS_SUBSCRIPTIONS WHERE CLIENTID=? AND NAME=?";
    protected String GET_USER_BY_CLIENTID = "SELECT USERID, PASSWD, CLIENTID FROM JMS_USERS WHERE CLIENTID=?";
    protected String GET_USER = "SELECT PASSWD, CLIENTID FROM JMS_USERS WHERE USERID=?";
    protected List POPULATE_TABLES = new ArrayList();

    public ObjectName getConnectionManager() {
        return this.connectionManagerName;
    }

    public void setConnectionManager(ObjectName connectionManagerName) {
        this.connectionManagerName = connectionManagerName;
    }

    public boolean hasSecurityManager() {
        return this.hasSecurityManager;
    }

    public void setHasSecurityManager(boolean hasSecurityManager) {
        this.hasSecurityManager = hasSecurityManager;
    }

    public String getSqlProperties() {
        try {
            ByteArrayOutputStream boa = new ByteArrayOutputStream();
            this.sqlProperties.store(boa, "");
            return new String(boa.toByteArray());
        }
        catch (IOException shouldnothappen) {
            return "";
        }
    }

    public void setSqlProperties(String value) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
            this.sqlProperties = new Properties();
            this.sqlProperties.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setConnectionRetryAttempts(int value) {
        this.connectionRetryAttempts = value;
    }

    public int getConnectionRetryAttempts() {
        return this.connectionRetryAttempts;
    }

    protected AbstractStateManager.DurableSubscription getDurableSubscription(DurableSubscriptionID sub) throws JMSException {
        JDBCSession session = new JDBCSession();
        try {
            PreparedStatement statement = session.prepareStatement(this.GET_SUBSCRIPTION);
            statement.setString(1, sub.getClientID());
            statement.setString(2, sub.getSubscriptionName());
            ResultSet rs = statement.executeQuery();
            session.addResultSet(rs);
            if (!rs.next()) {
                AbstractStateManager.DurableSubscription durableSubscription = null;
                return durableSubscription;
            }
            AbstractStateManager.DurableSubscription durableSubscription = new AbstractStateManager.DurableSubscription(sub.getClientID(), sub.getSubscriptionName(), rs.getString(1), rs.getString(2));
            return durableSubscription;
        }
        catch (SQLException e) {
            session.setRollbackOnly();
            throw new SpyJMSException("Error getting durable subscription " + sub, e);
        }
        finally {
            session.close();
        }
    }

    protected void saveDurableSubscription(AbstractStateManager.DurableSubscription ds) throws JMSException {
        JDBCSession session = new JDBCSession();
        try {
            PreparedStatement statement = session.prepareStatement(this.LOCK_SUBSCRIPTION);
            statement.setString(1, ds.getClientID());
            statement.setString(2, ds.getName());
            ResultSet rs = statement.executeQuery();
            session.addResultSet(rs);
            if (!rs.next()) {
                statement = session.prepareStatement(this.INSERT_SUBSCRIPTION);
                statement.setString(1, ds.getClientID());
                statement.setString(2, ds.getName());
                statement.setString(3, ds.getTopic());
                statement.setString(4, ds.getSelector());
            } else {
                statement = session.prepareStatement(this.UPDATE_SUBSCRIPTION);
                statement.setString(1, ds.getTopic());
                statement.setString(2, ds.getSelector());
                statement.setString(3, ds.getClientID());
                statement.setString(4, ds.getName());
            }
            if (statement.executeUpdate() != 1) {
                session.setRollbackOnly();
                throw new SpyJMSException("Insert subscription failed " + ds);
            }
        }
        catch (SQLException e) {
            session.setRollbackOnly();
            throw new SpyJMSException("Error saving durable subscription " + ds, e);
        }
        finally {
            session.close();
        }
    }

    protected void removeDurableSubscription(AbstractStateManager.DurableSubscription ds) throws JMSException {
        JDBCSession session = new JDBCSession();
        try {
            PreparedStatement statement = session.prepareStatement(this.REMOVE_SUBSCRIPTION);
            statement.setString(1, ds.getClientID());
            statement.setString(2, ds.getName());
            if (statement.executeUpdate() != 1) {
                throw new JMSException("Durable subscription does not exist " + ds);
            }
        }
        catch (SQLException e) {
            session.setRollbackOnly();
            throw new SpyJMSException("Error removing durable subscription " + ds, e);
        }
        finally {
            session.close();
        }
    }

    public Collection getDurableSubscriptionIdsForTopic(SpyTopic topic) throws JMSException {
        ArrayList<DurableSubscriptionID> result = new ArrayList<DurableSubscriptionID>();
        JDBCSession session = new JDBCSession();
        try {
            PreparedStatement statement = session.prepareStatement(this.GET_SUBSCRIPTIONS_FOR_TOPIC);
            statement.setString(1, topic.getName());
            ResultSet rs = statement.executeQuery();
            session.addResultSet(rs);
            while (rs.next()) {
                result.add(new DurableSubscriptionID(rs.getString(1), rs.getString(2), rs.getString(3)));
            }
            ArrayList<DurableSubscriptionID> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            session.setRollbackOnly();
            throw new SpyJMSException("Error getting durable subscriptions for topic " + topic, e);
        }
        finally {
            session.close();
        }
    }

    protected void checkLoggedOnClientId(String clientID) throws JMSException {
        JDBCSession session = new JDBCSession();
        try {
            PreparedStatement statement = session.prepareStatement(this.GET_USER_BY_CLIENTID);
            statement.setString(1, clientID);
            ResultSet rs = statement.executeQuery();
            session.addResultSet(rs);
            if (rs.next()) {
                throw new InvalidClientIDException("This client id is password protected " + clientID);
            }
        }
        catch (SQLException e) {
            session.setRollbackOnly();
            throw new SpyJMSException("Error checking logged on client id " + clientID, e);
        }
        finally {
            session.close();
        }
    }

    protected String getPreconfClientId(String logon, String passwd) throws JMSException {
        JDBCSession session = new JDBCSession();
        try {
            PreparedStatement statement = session.prepareStatement(this.GET_USER);
            statement.setString(1, logon);
            ResultSet rs = statement.executeQuery();
            session.addResultSet(rs);
            if (!rs.next()) {
                if (this.hasSecurityManager) {
                    String string = null;
                    return string;
                }
                throw new JMSSecurityException("This user does not exist " + logon);
            }
            if (!this.hasSecurityManager && !passwd.equals(rs.getString(1))) {
                throw new JMSSecurityException("Bad password for user " + logon);
            }
            String string = rs.getString(2);
            return string;
        }
        catch (SQLException e) {
            session.setRollbackOnly();
            throw new SpyJMSException("Error retrieving preconfigured user " + logon, e);
        }
        finally {
            session.close();
        }
    }

    public StateManager getInstance() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        if (this.connectionManagerName == null) {
            throw new IllegalStateException("No connection manager configured");
        }
        String dsName = (String)this.getServer().getAttribute(this.connectionManagerName, "BindName");
        InitialContext ctx = new InitialContext();
        try {
            this.dataSource = (DataSource)ctx.lookup(dsName);
            this.tm = TransactionManagerLocator.locateTransactionManager();
        }
        finally {
            ctx.close();
        }
        try {
            this.initDB();
        }
        catch (Exception e) {
            log.warn("Error initialising state manager db", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDB() throws Exception {
        this.CREATE_USER_TABLE = this.sqlProperties.getProperty("CREATE_USER_TABLE", this.CREATE_USER_TABLE);
        this.CREATE_ROLE_TABLE = this.sqlProperties.getProperty("CREATE_ROLE_TABLE", this.CREATE_ROLE_TABLE);
        this.CREATE_SUBSCRIPTION_TABLE = this.sqlProperties.getProperty("CREATE_SUBSCRIPTION_TABLE", this.CREATE_SUBSCRIPTION_TABLE);
        this.GET_SUBSCRIPTION = this.sqlProperties.getProperty("GET_SUBSCRIPTION", this.GET_SUBSCRIPTION);
        this.GET_SUBSCRIPTIONS_FOR_TOPIC = this.sqlProperties.getProperty("GET_SUBSCRIPTIONS_FOR_TOPIC", this.GET_SUBSCRIPTIONS_FOR_TOPIC);
        this.LOCK_SUBSCRIPTION = this.sqlProperties.getProperty("LOCK_SUBSCRIPTION", this.LOCK_SUBSCRIPTION);
        this.INSERT_SUBSCRIPTION = this.sqlProperties.getProperty("INSERT_SUBSCRIPTION", this.INSERT_SUBSCRIPTION);
        this.UPDATE_SUBSCRIPTION = this.sqlProperties.getProperty("UPDATE_SUBSCRIPTION", this.UPDATE_SUBSCRIPTION);
        this.REMOVE_SUBSCRIPTION = this.sqlProperties.getProperty("REMOVE_SUBSCRIPTION", this.REMOVE_SUBSCRIPTION);
        this.GET_USER_BY_CLIENTID = this.sqlProperties.getProperty("GET_USER_BY_CLIENTID", this.GET_USER_BY_CLIENTID);
        this.GET_USER = this.sqlProperties.getProperty("GET_USER", this.GET_USER);
        Iterator<Map.Entry<Object, Object>> i = this.sqlProperties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("POPULATE.TABLES.")) continue;
            this.POPULATE_TABLES.add(entry.getValue());
        }
        String createString = this.sqlProperties.getProperty("CREATE_TABLES_ON_START_UP");
        if (createString == null) {
            createString = this.sqlProperties.getProperty("CREATE_TABLES_ON_STARTUP");
        }
        this.createTables = createString == null ? true : createString.trim().equalsIgnoreCase("true");
        if (this.createTables) {
            JDBCSession session = new JDBCSession();
            try {
                PreparedStatement statement;
                try {
                    statement = session.prepareStatement(this.CREATE_USER_TABLE);
                    statement.executeUpdate();
                }
                catch (SQLException ignored) {
                    log.trace("Error creating table: " + this.CREATE_USER_TABLE, ignored);
                }
                try {
                    statement = session.prepareStatement(this.CREATE_ROLE_TABLE);
                    statement.executeUpdate();
                }
                catch (SQLException ignored) {
                    log.trace("Error creating table: " + this.CREATE_ROLE_TABLE, ignored);
                }
                try {
                    statement = session.prepareStatement(this.CREATE_SUBSCRIPTION_TABLE);
                    statement.executeUpdate();
                }
                catch (SQLException ignored) {
                    log.trace("Error creating table: " + this.CREATE_SUBSCRIPTION_TABLE, ignored);
                }
                Iterator iter = this.POPULATE_TABLES.iterator();
                String nextQry = null;
                while (iter.hasNext()) {
                    try {
                        nextQry = (String)iter.next();
                        statement = session.prepareStatement(nextQry);
                        statement.execute();
                    }
                    catch (SQLException ignored) {
                        log.trace("Error populating tables: " + nextQry, ignored);
                    }
                }
            }
            finally {
                session.close();
            }
        }
    }

    class JDBCSession {
        boolean trace = log.isTraceEnabled();
        Transaction threadTx;
        boolean rollback = false;
        Connection connection;
        HashSet statements = new HashSet();
        HashSet resultSets = null;

        JDBCSession() throws JMSException {
            try {
                this.threadTx = JDBCStateManager.this.tm.suspend();
                try {
                    JDBCStateManager.this.tm.begin();
                    try {
                        this.connection = this.getConnection();
                    }
                    catch (Throwable t) {
                        try {
                            JDBCStateManager.this.tm.rollback();
                        }
                        catch (Throwable ignored) {
                            log.warn("Unable to rollback transaction", ignored);
                        }
                        throw t;
                    }
                }
                catch (Throwable t) {
                    try {
                        if (this.threadTx != null) {
                            JDBCStateManager.this.tm.resume(this.threadTx);
                        }
                    }
                    catch (Throwable ignored) {
                        log.warn("Unable to resume transaction " + this.threadTx, ignored);
                    }
                    throw t;
                }
            }
            catch (Throwable t) {
                throw new SpyJMSException("Error creating connection to the database.", t);
            }
        }

        PreparedStatement prepareStatement(String sql) throws SQLException {
            PreparedStatement result = this.connection.prepareStatement(sql);
            this.statements.add(result);
            return result;
        }

        void setRollbackOnly() throws JMSException {
            this.rollback = true;
        }

        void addResultSet(ResultSet rs) {
            if (this.resultSets == null) {
                this.resultSets = new HashSet();
            }
            this.resultSets.add(rs);
        }

        void close() throws JMSException {
            block22: {
                Iterator i;
                if (this.resultSets != null) {
                    i = this.resultSets.iterator();
                    while (i.hasNext()) {
                        ResultSet rs = (ResultSet)i.next();
                        try {
                            rs.close();
                        }
                        catch (Throwable ignored) {
                            if (!this.trace) continue;
                            log.trace("Unable to close result set", ignored);
                        }
                    }
                }
                i = this.statements.iterator();
                while (i.hasNext()) {
                    Statement s = (Statement)i.next();
                    try {
                        s.close();
                    }
                    catch (Throwable ignored) {
                        if (!this.trace) continue;
                        log.trace("Unable to close statement", ignored);
                    }
                }
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (Throwable ignored) {
                    if (!this.trace) break block22;
                    log.trace("Unable to close connection", ignored);
                }
            }
            try {
                if (this.rollback) {
                    JDBCStateManager.this.tm.rollback();
                } else {
                    JDBCStateManager.this.tm.commit();
                }
            }
            catch (Exception e) {
                throw new SpyJMSException("Could not commit/rollback a transaction with the transaction manager.", e);
            }
            finally {
                try {
                    if (this.threadTx != null) {
                        JDBCStateManager.this.tm.resume(this.threadTx);
                    }
                }
                catch (Throwable ignored) {
                    log.warn("Unable to resume transaction " + this.threadTx, ignored);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Connection getConnection() throws SQLException {
            int attempts = JDBCStateManager.this.connectionRetryAttempts;
            int attemptCount = 0;
            SQLException sqlException = null;
            while (attempts-- > 0) {
                if (++attemptCount > 1) {
                    log.debug("Retrying connection: attempt # " + attemptCount);
                }
                try {
                    sqlException = null;
                    Connection connection = JDBCStateManager.this.dataSource.getConnection();
                    return connection;
                }
                catch (SQLException exception) {
                    log.debug("Connection attempt # " + attemptCount + " failed with SQLException", exception);
                    sqlException = exception;
                }
                finally {
                    if (sqlException == null && attemptCount > 1) {
                        log.debug("Connection succeeded on attempt # " + attemptCount);
                    }
                }
                if (attempts <= 0) continue;
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            if (sqlException != null) {
                throw sqlException;
            }
            throw new SQLException("connection attempt interrupted");
        }
    }
}

