/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.ws.core.utils.ResourceURL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBossWSEntityResolver
extends JBossEntityResolver {
    private static final Logger log = Logger.getLogger(JBossWSEntityResolver.class);

    public JBossWSEntityResolver() {
        JBossWSEntityResolver.registerEntity("urn:jboss:jaxrpc-config:2.0", "schema/jaxrpc-config_2_0.xsd");
        JBossWSEntityResolver.registerEntity("urn:jboss:jaxws-config:2.0", "schema/jaxws-config_2_0.xsd");
        JBossWSEntityResolver.registerEntity("http://java.sun.com/xml/ns/javaee", "schema/javaee_web_services_1_2.xsd");
        JBossWSEntityResolver.registerEntity("http://www.w3.org/2005/08/addressing", "schema/ws-addr.xsd");
        JBossWSEntityResolver.registerEntity("http://schemas.xmlsoap.org/ws/2004/08/eventing", "eventing.xsd");
        JBossWSEntityResolver.registerEntity("http://www.w3.org/2002/06/soap-encoding", "soap-encoding_200206.xsd");
        JBossWSEntityResolver.registerEntity("http://schemas.xmlsoap.org/soap/encoding/", "soap-encoding_1_1.xsd");
        JBossWSEntityResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", "j2ee_web_services_client_1_1.xsd");
        JBossWSEntityResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", "j2ee_web_services_1_1.xsd");
        JBossWSEntityResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_jaxrpc_mapping_1_1.xsd", "j2ee_jaxrpc_mapping_1_1.xsd");
        JBossWSEntityResolver.registerEntity("http://ws-i.org/profiles/basic/1.1/swaref.xsd", "schema/swaref.xsd");
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        if (log.isDebugEnabled()) {
            log.debug("resolveEntity: [pub=" + publicId + ",sysid=" + systemId + "]");
        }
        if ((inputSource = super.resolveEntity(publicId, systemId)) == null) {
            inputSource = this.resolveSystemIDAsURL(systemId, log.isTraceEnabled());
        }
        if (inputSource == null) {
            log.debug("Cannot resolve entity: [pub=" + publicId + ",sysid=" + systemId + "]");
        }
        return inputSource;
    }

    protected InputSource resolveSystemIDAsURL(String id, boolean trace) {
        InputSource inputSource;
        block11: {
            if (id == null) {
                return null;
            }
            if (trace) {
                log.trace("resolveIDAsResourceURL, id=" + id);
            }
            inputSource = null;
            try {
                InputStream ins;
                URL url;
                if (trace) {
                    log.trace("Trying to resolve id as a URL");
                }
                if (!(url = new URL(id)).getProtocol().equalsIgnoreCase("file")) {
                    log.warn("Trying to resolve id as a non-file URL: " + id);
                }
                if ((ins = new ResourceURL(url).openStream()) != null) {
                    inputSource = new InputSource(ins);
                    inputSource.setSystemId(id);
                } else {
                    log.warn("Cannot load id as URL: " + id);
                }
                if (trace) {
                    log.trace("Resolved id as a URL");
                }
            }
            catch (MalformedURLException ignored) {
                if (trace) {
                    log.trace("id is not a url: " + id, ignored);
                }
            }
            catch (IOException e) {
                if (!trace) break block11;
                log.trace("Failed to obtain URL.InputStream from id: " + id, e);
            }
        }
        return inputSource;
    }
}

