/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.lang.reflect.Modifier;
import org.hibernate.bytecode.BytecodeProvider;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.ProxyFactoryFactory;
import org.hibernate.bytecode.ReflectionOptimizer;
import org.hibernate.bytecode.cglib.AccessOptimizerAdapter;
import org.hibernate.bytecode.cglib.CglibClassTransformer;
import org.hibernate.bytecode.cglib.InstantiationOptimizerAdapter;
import org.hibernate.bytecode.cglib.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.cglib.ReflectionOptimizerImpl;
import org.hibernate.bytecode.util.ClassFilter;
import org.hibernate.bytecode.util.FieldFilter;
import org.hibernate.repackage.cglib.beans.BulkBean;
import org.hibernate.repackage.cglib.beans.BulkBeanException;
import org.hibernate.repackage.cglib.reflect.FastClass;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final Logger log = LoggerFactory.getLogger((Class)BytecodeProviderImpl.class);

    public BytecodeProviderImpl() {
        log.warn("The CGLIB BytecodeProvider impl is considered deprecated and not recommended for use");
    }

    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl();
    }

    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        BulkBean bulkBean;
        FastClass fastClass;
        try {
            fastClass = FastClass.create(clazz);
            bulkBean = BulkBean.create(clazz, getterNames, setterNames, types);
            if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                if (fastClass == null) {
                    bulkBean = null;
                } else {
                    Object instance = fastClass.newInstance();
                    bulkBean.setPropertyValues(instance, bulkBean.getPropertyValues(instance));
                }
            }
        }
        catch (Throwable t) {
            int index;
            fastClass = null;
            bulkBean = null;
            String message = "reflection optimizer disabled for: " + clazz.getName() + " [" + StringHelper.unqualify(t.getClass().getName()) + ": " + t.getMessage();
            if (t instanceof BulkBeanException && (index = ((BulkBeanException)t).getIndex()) >= 0) {
                message = message + " (property " + setterNames[index] + ")";
            }
            log.debug(message);
        }
        if (fastClass != null && bulkBean != null) {
            return new ReflectionOptimizerImpl(new InstantiationOptimizerAdapter(fastClass), new AccessOptimizerAdapter(bulkBean, clazz));
        }
        return null;
    }

    public ClassTransformer getTransformer(ClassFilter classFilter, FieldFilter fieldFilter) {
        return new CglibClassTransformer(classFilter, fieldFilter);
    }
}

