/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.logging;

import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jboss.logging.XLevel;
import org.jboss.test.logging.LoggingPlugin;

public class Log4jLoggingPlugin
extends LoggingPlugin {
    public void enableTrace(String name) {
        Logger.getLogger((String)name).setLevel((Level)XLevel.TRACE);
    }

    public void setUp() throws Exception {
        URL url;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String file = System.getProperty("log4j.configuration");
        if (file == null && (url = cl.getResource("test-log4j.xml")) != null) {
            System.setProperty("log4j.configuration", "test-log4j.xml");
            BasicConfigurator.configure();
            return;
        }
        url = cl.getResource("log4j.xml");
        if (url != null) {
            System.err.println("Found log4j.xml: " + url);
            System.err.flush();
            return;
        }
        url = cl.getResource("log4j.properties");
        if (url != null) {
            System.err.println("Found log4j.properties: " + url);
            System.err.flush();
            return;
        }
        BasicConfigurator.resetConfiguration();
        PatternLayout layout = new PatternLayout("%r %-5p [%c{1}] %m%n");
        ConsoleAppender appender = new ConsoleAppender((Layout)layout);
        BasicConfigurator.configure((Appender)appender);
        file = System.getProperty("org.jboss.test.logfile");
        if (file != null) {
            FileAppender fileAppender = new FileAppender((Layout)layout, file);
            BasicConfigurator.configure((Appender)fileAppender);
        }
    }
}

