/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.forge.parser.ParserException;
import org.jboss.forge.parser.Streams;
import org.jboss.forge.parser.java.JavaType;
import org.jboss.forge.parser.java.source.JavaSource;
import org.jboss.forge.parser.spi.JavaParserProvider;

public final class JavaParser {
    private static List<JavaParserProvider> parsers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<JavaParserProvider> getParsers() {
        Class<JavaParser> clazz = JavaParser.class;
        synchronized (JavaParser.class) {
            if (parsers == null) {
                parsers = new ArrayList<JavaParserProvider>();
                for (JavaParserProvider p : ServiceLoader.load(JavaParserProvider.class)) {
                    parsers.add(p);
                }
            }
            if (parsers.size() == 0) {
                throw new IllegalStateException("No instances of [" + JavaParserProvider.class.getName() + "] were found on the classpath.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return parsers;
        }
    }

    public static <T extends JavaSource<?>> T create(Class<T> type) {
        for (JavaParserProvider parser : JavaParser.getParsers()) {
            T result = parser.create(type);
            if (result == null) continue;
            return result;
        }
        throw new ParserException("Cannot find JavaParserProvider capable of producing JavaSource of type " + type.getSimpleName(), new IllegalArgumentException(type.getName()));
    }

    public static JavaType<?> parse(File file) throws FileNotFoundException {
        return JavaParser.parse(JavaType.class, file);
    }

    public static JavaType<?> parse(URL data) throws IOException {
        return JavaParser.parse(JavaType.class, data);
    }

    public static JavaType<?> parse(InputStream data) {
        return JavaParser.parse(JavaType.class, data);
    }

    public static JavaType<?> parse(char[] data) {
        return JavaParser.parse(JavaType.class, data);
    }

    public static JavaType<?> parse(String data) {
        return JavaParser.parse(JavaType.class, data);
    }

    public static <T extends JavaType<?>> T parse(Class<T> type, URL url) throws IOException {
        return JavaParser.internalParse(type, url.openStream());
    }

    public static <T extends JavaType<?>> T parse(Class<T> type, File file) throws FileNotFoundException {
        return JavaParser.internalParse(type, new FileInputStream(file));
    }

    public static <T extends JavaType<?>> T parse(Class<T> type, char[] data) {
        return JavaParser.parse(type, new String(data));
    }

    public static <T extends JavaType<?>> T parse(Class<T> type, String data) {
        return JavaParser.parse(type, Streams.fromString(data));
    }

    public static <T extends JavaType<?>> T parse(Class<T> type, InputStream data) {
        for (JavaParserProvider parser : JavaParser.getParsers()) {
            JavaType<?> source = parser.parse(data);
            if (type.isInstance(source)) {
                JavaType<?> result = source;
                return (T)result;
            }
            if (source == null) continue;
            throw new ParserException("Source does not represent a [" + type.getSimpleName() + "], instead was [" + source.getClass().getSimpleName() + "] - Cannot convert.");
        }
        throw new ParserException("Cannot find JavaParserProvider capable of parsing the requested data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends JavaType<?>> T internalParse(Class<T> type, InputStream data) {
        try {
            T t = JavaParser.parse(type, data);
            return t;
        }
        finally {
            Streams.closeQuietly(data);
        }
    }
}

