/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.Type;
import org.jboss.forge.parser.java.util.Types;

public class TypeImpl<O extends JavaSource<O>>
implements Type<O> {
    private O origin = null;
    private final Type<O> parent;
    private AST ast = null;
    private CompilationUnit cu = null;
    private final org.eclipse.jdt.core.dom.Type type;

    private void init(O origin) {
        this.origin = origin;
        this.cu = (CompilationUnit)origin.getInternal();
        this.ast = this.cu.getAST();
    }

    public TypeImpl(O origin, Object internal) {
        this.init(origin);
        this.type = (org.eclipse.jdt.core.dom.Type)internal;
        this.parent = null;
    }

    public TypeImpl(O origin, Type<O> parent, String type) {
        org.eclipse.jdt.core.dom.Type subtree;
        this.init(origin);
        this.parent = parent;
        String stub = "public class Stub { private " + type + " getType(){return null;} }";
        JavaClass temp = (JavaClass)JavaParser.parse((String)stub);
        List methods = temp.getMethods();
        MethodDeclaration newMethod = (MethodDeclaration)((Method)methods.get(0)).getInternal();
        this.type = subtree = (org.eclipse.jdt.core.dom.Type)ASTNode.copySubtree((AST)this.cu.getAST(), (ASTNode)newMethod.getReturnType2());
    }

    public TypeImpl(O origin, Type<O> parent, Object internal) {
        this.init(origin);
        this.parent = parent;
        this.type = (org.eclipse.jdt.core.dom.Type)internal;
    }

    public O getOrigin() {
        return this.origin;
    }

    public List<Type<O>> getTypeArguments() {
        ArrayList<Type<O>> result = new ArrayList<Type<O>>();
        org.eclipse.jdt.core.dom.Type type = this.type;
        if (type instanceof ArrayType) {
            type = ((ArrayType)type).getComponentType();
        }
        if (type instanceof ParameterizedType) {
            List arguments = ((ParameterizedType)type).typeArguments();
            for (org.eclipse.jdt.core.dom.Type t : arguments) {
                result.add(new TypeImpl<O>(this.origin, this, t));
            }
        }
        return result;
    }

    public boolean isArray() {
        return this.type.isArrayType();
    }

    public boolean isParameterized() {
        if (this.type instanceof ArrayType) {
            return ((ArrayType)this.type).getComponentType().isParameterizedType();
        }
        return this.type.isParameterizedType();
    }

    public boolean isPrimitive() {
        if (this.type instanceof ArrayType) {
            return ((ArrayType)this.type).getComponentType().isPrimitiveType();
        }
        return this.type.isPrimitiveType();
    }

    public boolean isQualified() {
        if (this.type instanceof ArrayType) {
            return ((ArrayType)this.type).getComponentType().isQualifiedType();
        }
        return this.type.isQualifiedType();
    }

    public boolean isWildcard() {
        if (this.type instanceof ArrayType) {
            return ((ArrayType)this.type).getComponentType().isWildcardType();
        }
        return this.type.isWildcardType();
    }

    public String getName() {
        String result = this.type.toString();
        if (this.isParameterized()) {
            if (this.isArray()) {
                result = Types.stripArray((String)result);
            }
            result = Types.stripGenerics((String)result);
            if (this.isArray()) {
                result = result + "[]";
            }
        }
        return result;
    }

    public String getQualifiedName() {
        String result = this.type.toString();
        return this.origin.resolveType(result);
    }

    public Type<O> getParentType() {
        return this.parent;
    }

    public int getArrayDimensions() {
        if (this.isArray()) {
            return ((ArrayType)this.type).getDimensions();
        }
        return -1;
    }

    public String toString() {
        return this.type.toString();
    }
}

