/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Modifier;

public class ModifierAccessor {
    public boolean hasModifier(BodyDeclaration body, Modifier.ModifierKeyword modifier) {
        boolean result = false;
        List<Modifier> modifiers = this.getModifiers(body);
        for (Modifier m : modifiers) {
            if (m.getKeyword() != modifier) continue;
            result = true;
        }
        return result;
    }

    private List<Modifier> getModifiers(BodyDeclaration body) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        List modifiers = body.modifiers();
        for (Object m : modifiers) {
            if (!(m instanceof Modifier)) continue;
            Modifier mod = (Modifier)m;
            result.add(mod);
        }
        return result;
    }

    public List<Modifier> clearVisibility(BodyDeclaration body) {
        List<Modifier> modifiers = this.getModifiers(body);
        ArrayList<Modifier> toBeRemoved = new ArrayList<Modifier>();
        for (Modifier modifier : modifiers) {
            if (!modifier.isPrivate() && !modifier.isProtected() && !modifier.isPublic()) continue;
            toBeRemoved.add(modifier);
        }
        body.modifiers().removeAll(toBeRemoved);
        return modifiers;
    }

    public void addModifier(BodyDeclaration body, Modifier.ModifierKeyword keyword) {
        body.modifiers().add(body.getAST().newModifier(keyword));
    }

    public void removeModifier(BodyDeclaration body, Modifier.ModifierKeyword keyword) {
        List<Modifier> modifiers = this.getModifiers(body);
        ArrayList<Modifier> toBeRemoved = new ArrayList<Modifier>();
        for (Modifier modifier : modifiers) {
            if (!modifier.getKeyword().equals(keyword)) continue;
            toBeRemoved.add(modifier);
        }
        body.modifiers().removeAll(toBeRemoved);
    }
}

