/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.Document;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.FieldHolder;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.MethodHolder;
import org.jboss.forge.parser.java.Parameter;
import org.jboss.forge.parser.java.ast.MethodFinderVisitor;
import org.jboss.forge.parser.java.impl.AbstractJavaSource;
import org.jboss.forge.parser.java.impl.FieldImpl;
import org.jboss.forge.parser.java.impl.MethodImpl;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;

public abstract class AbstractJavaSourceMemberHolder<O extends JavaSource<O>>
extends AbstractJavaSource<O>
implements MethodHolder<O>,
FieldHolder<O> {
    public AbstractJavaSourceMemberHolder(JavaSource<?> enclosingType, Document document, CompilationUnit unit, BodyDeclaration declaration) {
        super(enclosingType, document, unit, declaration);
    }

    public Field<O> addField() {
        FieldImpl<AbstractJavaSourceMemberHolder> field = new FieldImpl<AbstractJavaSourceMemberHolder>(this);
        this.addField(field);
        return field;
    }

    public Field<O> addField(String declaration) {
        String stub = "public class Stub { " + declaration + " }";
        JavaClass temp = (JavaClass)JavaParser.parse((String)stub);
        List fields = temp.getFields();
        FieldImpl<AbstractJavaSourceMemberHolder> result = null;
        for (Field stubField : fields) {
            Object variableDeclaration = stubField.getInternal();
            FieldImpl<AbstractJavaSourceMemberHolder> field = new FieldImpl<AbstractJavaSourceMemberHolder>(this, variableDeclaration, true);
            this.addField(field);
            if (result != null) continue;
            result = field;
        }
        return result;
    }

    private void addField(Field<O> field) {
        List bodyDeclarations = this.getBodyDeclaration().bodyDeclarations();
        int idx = 0;
        for (Object object : bodyDeclarations) {
            if (!(object instanceof FieldDeclaration)) break;
            ++idx;
        }
        bodyDeclarations.add(idx, ((VariableDeclarationFragment)field.getInternal()).getParent());
    }

    @Override
    public List<Member<O, ?>> getMembers() {
        ArrayList result = new ArrayList();
        result.addAll(this.getFields());
        result.addAll(this.getMethods());
        return result;
    }

    public List<Field<O>> getFields() {
        ArrayList<FieldImpl<AbstractJavaSourceMemberHolder>> result = new ArrayList<FieldImpl<AbstractJavaSourceMemberHolder>>();
        List bodyDeclarations = this.getBodyDeclaration().bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (!(bodyDeclaration instanceof FieldDeclaration)) continue;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
            List fragments = fieldDeclaration.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                result.add(new FieldImpl<AbstractJavaSourceMemberHolder>(this, fragment));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public Field<O> getField(String name) {
        for (Field<O> field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public boolean hasField(String name) {
        for (Field<O> field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasField(Field<O> field) {
        return this.getFields().contains(field);
    }

    public O removeField(Field<O> field) {
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.getInternal();
        Iterator declarationsIterator = this.getBodyDeclaration().bodyDeclarations().iterator();
        while (declarationsIterator.hasNext()) {
            List fragments;
            FieldDeclaration declaration;
            Object next = declarationsIterator.next();
            if (!(next instanceof FieldDeclaration) || !(declaration = (FieldDeclaration)next).equals((Object)fragment.getParent()) || !(fragments = declaration.fragments()).contains(fragment)) continue;
            if (fragments.size() == 1) {
                declarationsIterator.remove();
                break;
            }
            fragments.remove(fragment);
            break;
        }
        return (O)this;
    }

    public boolean hasMethod(Method<O> method) {
        return this.getMethods().contains(method);
    }

    public boolean hasMethodSignature(String name) {
        return this.hasMethodSignature(name, new String[0]);
    }

    public boolean hasMethodSignature(String name, String ... paramTypes) {
        return this.getMethod(name, paramTypes) != null;
    }

    public boolean hasMethodSignature(String name, Class<?> ... paramTypes) {
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        String[] types = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            types[i] = paramTypes[i].getName();
        }
        return this.hasMethodSignature(name, types);
    }

    public Method<O> getMethod(String name) {
        for (Method<O> method : this.getMethods()) {
            if (!method.getName().equals(name) || method.getParameters().size() != 0) continue;
            return method;
        }
        return null;
    }

    public Method<O> getMethod(String name, String ... paramTypes) {
        for (Method<O> local : this.getMethods()) {
            if (!local.getName().equals(name)) continue;
            List localParams = local.getParameters();
            if (paramTypes == null || !localParams.isEmpty() && localParams.size() != paramTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < localParams.size(); ++i) {
                Parameter localParam = (Parameter)localParams.get(i);
                String type = paramTypes[i];
                if (Types.areEquivalent((String)localParam.getType(), (String)type)) continue;
                matches = false;
            }
            if (!matches) continue;
            return local;
        }
        return null;
    }

    public Method<O> getMethod(String name, Class<?> ... paramTypes) {
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        String[] types = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            types[i] = paramTypes[i].getName();
        }
        return this.getMethod(name, types);
    }

    public boolean hasMethodSignature(Method<?> method) {
        for (Method<O> local : this.getMethods()) {
            if (!local.getName().equals(method.getName())) continue;
            Iterator localParams = local.getParameters().iterator();
            for (Parameter methodParam : method.getParameters()) {
                if (localParams.hasNext() && Strings.areEqual((String)((Parameter)localParams.next()).getType(), (String)methodParam.getType())) continue;
                return false;
            }
            return !localParams.hasNext();
        }
        return false;
    }

    public O removeMethod(Method<O> method) {
        this.getBodyDeclaration().bodyDeclarations().remove(method.getInternal());
        return (O)this;
    }

    public Method<O> addMethod() {
        MethodImpl<AbstractJavaSourceMemberHolder> m = new MethodImpl<AbstractJavaSourceMemberHolder>(this);
        this.getBodyDeclaration().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public Method<O> addMethod(String method) {
        MethodImpl<AbstractJavaSourceMemberHolder> m = new MethodImpl<AbstractJavaSourceMemberHolder>(this, method);
        this.getBodyDeclaration().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public List<Method<O>> getMethods() {
        ArrayList<MethodImpl<AbstractJavaSourceMemberHolder>> result = new ArrayList<MethodImpl<AbstractJavaSourceMemberHolder>>();
        MethodFinderVisitor methodFinderVisitor = new MethodFinderVisitor();
        this.body.accept((ASTVisitor)methodFinderVisitor);
        List<MethodDeclaration> methods = methodFinderVisitor.getMethods();
        for (MethodDeclaration methodDeclaration : methods) {
            result.add(new MethodImpl<AbstractJavaSourceMemberHolder>(this, methodDeclaration));
        }
        return Collections.unmodifiableList(result);
    }
}

