/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.AnnotationTarget;
import org.jboss.forge.parser.java.EnumConstant;
import org.jboss.forge.parser.java.JavaEnum;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.ast.AnnotationAccessor;
import org.jboss.forge.parser.java.impl.EnumConstantBodyImpl;
import org.jboss.forge.parser.java.util.Strings;

public class EnumConstantImpl<O extends JavaSource<O>>
implements EnumConstant<O> {
    private final AnnotationAccessor<O, EnumConstant<O>> annotations = new AnnotationAccessor();
    private O parent;
    private AST ast;
    private EnumConstantDeclaration enumConstant;

    private void init(O parent) {
        this.parent = parent;
        this.ast = ((ASTNode)parent.getInternal()).getAST();
    }

    public EnumConstantImpl(O parent) {
        this.init(parent);
        this.enumConstant = this.ast.newEnumConstantDeclaration();
    }

    public EnumConstantImpl(O parent, String declaration) {
        EnumConstantDeclaration subtree;
        this.init(parent);
        String stub = "public enum Stub { " + declaration + " }";
        JavaEnum temp = (JavaEnum)JavaParser.parse((String)stub);
        List constants = temp.getEnumConstants();
        EnumConstantDeclaration newField = (EnumConstantDeclaration)((EnumConstant)constants.get(0)).getInternal();
        this.enumConstant = subtree = (EnumConstantDeclaration)ASTNode.copySubtree((AST)this.ast, (ASTNode)newField);
    }

    public EnumConstantImpl(O parent, Object internal) {
        this.init(parent);
        this.enumConstant = (EnumConstantDeclaration)internal;
    }

    public String getName() {
        return this.enumConstant.getName().getFullyQualifiedName();
    }

    public EnumConstant<O> setName(String name) {
        this.enumConstant.setName(this.ast.newSimpleName(name));
        return this;
    }

    public Object getInternal() {
        return this.enumConstant;
    }

    public O getOrigin() {
        return this.parent;
    }

    public List<String> getConstructorArguments() {
        ArrayList<String> result = new ArrayList<String>();
        for (Object o : this.enumConstant.arguments()) {
            result.add(o.toString());
        }
        return Collections.unmodifiableList(result);
    }

    public EnumConstant<O> setConstructorArguments(String ... literalArguments) {
        this.enumConstant.arguments().clear();
        if (literalArguments != null && literalArguments.length > 0) {
            String stub = "public enum Stub { FOO(" + Strings.join(Arrays.asList(literalArguments), (String)", ") + "); }";
            JavaEnum temp = (JavaEnum)JavaParser.parse(JavaEnum.class, (String)stub);
            List constants = temp.getEnumConstants();
            EnumConstantDeclaration newConstant = (EnumConstantDeclaration)((EnumConstant)constants.get(0)).getInternal();
            List arguments = newConstant.arguments();
            for (Expression argument : arguments) {
                Expression subtree = (Expression)ASTNode.copySubtree((AST)this.ast, (ASTNode)argument);
                this.enumConstant.arguments().add(subtree);
            }
        }
        return this;
    }

    public EnumConstant.Body getBody() {
        return new EnumConstantBodyImpl((JavaEnum)this.parent, this);
    }

    public EnumConstant<O> removeBody() {
        this.enumConstant.setAnonymousClassDeclaration(null);
        return this;
    }

    public Annotation<O> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTarget<O, EnumConstant<O>>)this, (ASTNode)this.enumConstant);
    }

    public Annotation<O> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        if (!this.parent.hasImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.annotations.addAnnotation((AnnotationTarget<O, EnumConstant<O>>)this, (ASTNode)this.enumConstant, clazz.getSimpleName());
    }

    public Annotation<O> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTarget<O, EnumConstant<O>>)this, (ASTNode)this.enumConstant, className);
    }

    public List<Annotation<O>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTarget<O, EnumConstant<O>>)this, (ASTNode)this.enumConstant);
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, (ASTNode)this.enumConstant, type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, (ASTNode)this.enumConstant, type);
    }

    public EnumConstant<O> removeAnnotation(Annotation<O> annotation) {
        return this.annotations.removeAnnotation(this, (ASTNode)this.enumConstant, annotation);
    }

    public Annotation<O> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTarget<O, EnumConstant<O>>)this, (ASTNode)this.enumConstant, (Class<java.lang.annotation.Annotation>)type);
    }

    public Annotation<O> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTarget<O, EnumConstant<O>>)this, (ASTNode)this.enumConstant, type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        EnumConstantImpl other = (EnumConstantImpl)obj;
        return other.enumConstant == this.enumConstant || other.enumConstant != null && other.enumConstant.equals((Object)this.enumConstant);
    }

    public int hashCode() {
        int result = 912;
        return result | (this.enumConstant == null ? 0 : this.enumConstant.hashCode());
    }

    public String toString() {
        return this.enumConstant.toString();
    }
}

