/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.jboss.forge.parser.ParserException;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.AnnotationTarget;
import org.jboss.forge.parser.java.Import;
import org.jboss.forge.parser.java.JavaPackageInfo;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.SourceType;
import org.jboss.forge.parser.java.SyntaxError;
import org.jboss.forge.parser.java.Visibility;
import org.jboss.forge.parser.java.VisibilityScoped;
import org.jboss.forge.parser.java.ast.AnnotationAccessor;
import org.jboss.forge.parser.java.ast.ModifierAccessor;
import org.jboss.forge.parser.java.ast.TypeDeclarationFinderVisitor;
import org.jboss.forge.parser.java.impl.ImportImpl;
import org.jboss.forge.parser.java.impl.SyntaxErrorImpl;
import org.jboss.forge.parser.java.util.Formatter;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;
import org.jboss.forge.parser.spi.JavaParserImpl;
import org.jboss.forge.parser.spi.WildcardImportResolver;

public class JavaPackageInfoImpl
implements JavaPackageInfo {
    private final AnnotationAccessor<JavaPackageInfo, JavaPackageInfo> annotations = new AnnotationAccessor();
    private final ModifierAccessor modifiers = new ModifierAccessor();
    protected final Document document;
    protected final CompilationUnit unit;
    protected final ASTNode pkg;
    protected final JavaSource<?> enclosingType;
    public static ServiceLoader<WildcardImportResolver> loader = ServiceLoader.load(WildcardImportResolver.class);
    private static List<WildcardImportResolver> resolvers;

    public JavaPackageInfoImpl(JavaSource<?> enclosingType, Document document, CompilationUnit unit, PackageDeclaration pkg) {
        this.enclosingType = enclosingType == null ? this : enclosingType;
        this.document = document;
        this.unit = unit;
        this.pkg = pkg;
    }

    public SourceType getSourceType() {
        return SourceType.PACKAGEINFO;
    }

    public String getName() {
        return "package-info";
    }

    public JavaSource<?> getEnclosingType() {
        return this.enclosingType;
    }

    public Annotation<JavaPackageInfo> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTarget<JavaPackageInfo, JavaPackageInfo>)this, (ASTNode)this.getPackageDeclaration());
    }

    public Annotation<JavaPackageInfo> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.addAnnotation((AnnotationTarget<JavaPackageInfo, JavaPackageInfo>)this, (ASTNode)this.getPackageDeclaration(), clazz.getName());
    }

    public Annotation<JavaPackageInfo> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTarget<JavaPackageInfo, JavaPackageInfo>)this, (ASTNode)this.getPackageDeclaration(), className);
    }

    public List<Annotation<JavaPackageInfo>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTarget<JavaPackageInfo, JavaPackageInfo>)this, (ASTNode)this.getPackageDeclaration());
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, (ASTNode)this.getPackageDeclaration(), type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, (ASTNode)this.getPackageDeclaration(), type);
    }

    public JavaPackageInfo removeAnnotation(Annotation<JavaPackageInfo> annotation) {
        return this.annotations.removeAnnotation(this, (ASTNode)this.getPackageDeclaration(), annotation);
    }

    public Annotation<JavaPackageInfo> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTarget<JavaPackageInfo, JavaPackageInfo>)this, (ASTNode)this.getPackageDeclaration(), type);
    }

    public Annotation<JavaPackageInfo> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTarget<JavaPackageInfo, JavaPackageInfo>)this, (ASTNode)this.getPackageDeclaration(), type);
    }

    public Import addImport(Class<?> type) {
        return this.addImport(type.getCanonicalName());
    }

    public <T extends JavaSource<?>> Import addImport(T type) {
        String qualifiedName = type.getQualifiedName();
        return this.addImport(qualifiedName);
    }

    public Import addImport(Import imprt) {
        return this.addImport(imprt.getQualifiedName()).setStatic(imprt.isStatic());
    }

    public Import addImport(String className) {
        Import imprt;
        String strippedClassName = Types.stripGenerics((String)Types.stripArray((String)className));
        if (Types.isSimpleName((String)strippedClassName) && !this.hasImport(strippedClassName)) {
            throw new IllegalArgumentException("Cannot import class without a package [" + strippedClassName + "]");
        }
        if (!this.hasImport(strippedClassName) && this.validImport(strippedClassName)) {
            imprt = new ImportImpl((JavaSource<?>)this).setName(strippedClassName);
            this.unit.imports().add(imprt.getInternal());
        } else if (this.hasImport(strippedClassName)) {
            imprt = this.getImport(strippedClassName);
        } else {
            throw new IllegalArgumentException("Attempted to import the illegal type [" + strippedClassName + "]");
        }
        return imprt;
    }

    public Import getImport(String className) {
        List<Import> imports = this.getImports();
        for (Import imprt : imports) {
            if (!imprt.getQualifiedName().equals(className) && !imprt.getSimpleName().equals(className)) continue;
            return imprt;
        }
        return null;
    }

    public Import getImport(Class<?> type) {
        return this.getImport(type.getName());
    }

    public <T extends JavaSource<?>> Import getImport(T type) {
        return this.getImport(type.getQualifiedName());
    }

    public Import getImport(Import imprt) {
        return this.getImport(imprt.getQualifiedName());
    }

    public List<Import> getImports() {
        ArrayList<ImportImpl> results = new ArrayList<ImportImpl>();
        for (ImportDeclaration i : this.unit.imports()) {
            results.add(new ImportImpl((JavaSource<?>)this, i));
        }
        return Collections.unmodifiableList(results);
    }

    public boolean hasImport(Class<?> type) {
        return this.hasImport(type.getName());
    }

    public <T extends JavaSource<T>> boolean hasImport(T type) {
        return this.hasImport(type.getQualifiedName());
    }

    public boolean hasImport(Import imprt) {
        return this.hasImport(imprt.getQualifiedName());
    }

    public boolean hasImport(String type) {
        String resultType = type;
        if (Types.isArray((String)type)) {
            resultType = Types.stripArray((String)type);
        }
        if (Types.isGeneric((String)type)) {
            resultType = Types.stripGenerics((String)type);
        }
        return this.getImport(resultType) != null;
    }

    public boolean requiresImport(Class<?> type) {
        return this.requiresImport(type.getName());
    }

    public boolean requiresImport(String type) {
        String resultType = type;
        if (Types.isArray((String)resultType)) {
            resultType = Types.stripArray((String)type);
        }
        if (Types.isGeneric((String)resultType)) {
            resultType = Types.stripGenerics((String)resultType);
        }
        return this.validImport(resultType) && !this.hasImport(resultType) && !Types.isJavaLang((String)resultType);
    }

    public String resolveType(String type) {
        String original = type;
        String result = type;
        if (Types.isArray((String)result)) {
            original = Types.stripArray((String)result);
            result = Types.stripArray((String)result);
        }
        if (Types.isGeneric((String)result)) {
            original = Types.stripGenerics((String)result);
            result = Types.stripGenerics((String)result);
        }
        if (Types.isPrimitive((String)result)) {
            return result;
        }
        if (Types.isSimpleName((String)result)) {
            if (!this.hasImport(type) && Types.isJavaLang((String)type)) {
                result = "java.lang." + result;
            }
            if (result.equals(original)) {
                for (Import imprt : this.getImports()) {
                    if (!Types.areEquivalent((String)result, (String)imprt.getQualifiedName())) continue;
                    result = imprt.getQualifiedName();
                    break;
                }
            }
        }
        if (Types.isSimpleName((String)result)) {
            for (Import imprt : this.getImports()) {
                WildcardImportResolver r;
                if (!imprt.isWildcard()) continue;
                Iterator<WildcardImportResolver> i$ = this.getImportResolvers().iterator();
                while (i$.hasNext() && !Types.isQualified((String)(result = (r = i$.next()).resolve((JavaSource)this, result)))) {
                }
            }
        }
        if (Types.isSimpleName((String)result) && this.getPackage() != null) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    private List<WildcardImportResolver> getImportResolvers() {
        if (resolvers == null) {
            resolvers = new ArrayList<WildcardImportResolver>();
            for (WildcardImportResolver r : resolvers) {
                resolvers.add(r);
            }
        }
        if (resolvers.size() == 0) {
            throw new IllegalStateException("No instances of [" + WildcardImportResolver.class.getName() + "] were found on the classpath.");
        }
        return resolvers;
    }

    private boolean validImport(String type) {
        return !Strings.isNullOrEmpty((String)type) && !Types.isPrimitive((String)type);
    }

    public JavaPackageInfo removeImport(String name) {
        for (Import i : this.getImports()) {
            if (!i.getQualifiedName().equals(name)) continue;
            this.removeImport(i);
            break;
        }
        return this;
    }

    public JavaPackageInfo removeImport(Class<?> clazz) {
        return this.removeImport(clazz.getName());
    }

    public <T extends JavaSource<?>> JavaPackageInfo removeImport(T type) {
        return this.removeImport(type.getQualifiedName());
    }

    public JavaPackageInfo removeImport(Import imprt) {
        Object internal = imprt.getInternal();
        if (this.unit.imports().contains(internal)) {
            this.unit.imports().remove(internal);
        }
        return this;
    }

    public List<Member<JavaPackageInfo, ?>> getMembers() {
        return Collections.emptyList();
    }

    protected PackageDeclaration getPackageDeclaration() {
        if (this.pkg instanceof PackageDeclaration) {
            return (PackageDeclaration)this.pkg;
        }
        throw new ParserException("Source body was not of the expected type (PackageDeclaration).");
    }

    public JavaPackageInfo setName(String name) {
        throw new UnsupportedOperationException("Changing name of [" + this.getQualifiedName() + "] not supported.");
    }

    public String getCanonicalName() {
        String result = this.getName();
        for (JavaSource enclosingType = this; enclosingType != enclosingType.getEnclosingType(); enclosingType = enclosingType.getEnclosingType()) {
            enclosingType = this.getEnclosingType();
            result = enclosingType.getEnclosingType().getName() + "." + result;
        }
        if (!Strings.isNullOrEmpty((String)this.getPackage())) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    public String getQualifiedName() {
        String result = this.getName();
        for (JavaSource enclosingType = this; enclosingType != enclosingType.getEnclosingType(); enclosingType = enclosingType.getEnclosingType()) {
            enclosingType = this.getEnclosingType();
            result = enclosingType.getEnclosingType().getName() + "$" + result;
        }
        if (!Strings.isNullOrEmpty((String)this.getPackage())) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    public String getPackage() {
        PackageDeclaration pkg = this.unit.getPackage();
        if (pkg != null) {
            return pkg.getName().getFullyQualifiedName();
        }
        return null;
    }

    public JavaPackageInfo setPackage(String name) {
        if (this.unit.getPackage() == null) {
            this.unit.setPackage(this.unit.getAST().newPackageDeclaration());
        }
        this.unit.getPackage().setName(this.unit.getAST().newName(name));
        return this;
    }

    public JavaPackageInfo setDefaultPackage() {
        this.unit.setPackage(null);
        return this;
    }

    public boolean isDefaultPackage() {
        return this.unit.getPackage() == null;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public JavaPackageInfo setPackagePrivate() {
        this.modifiers.clearVisibility((ASTNode)this.getPackageDeclaration());
        return this;
    }

    public boolean isPublic() {
        return this.modifiers.hasModifier((ASTNode)this.getPackageDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public JavaPackageInfo setPublic() {
        this.modifiers.clearVisibility((ASTNode)this.getPackageDeclaration());
        this.modifiers.addModifier((ASTNode)this.getPackageDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return this;
    }

    public boolean isPrivate() {
        return this.modifiers.hasModifier((ASTNode)this.getPackageDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public JavaPackageInfo setPrivate() {
        this.modifiers.clearVisibility((ASTNode)this.getPackageDeclaration());
        this.modifiers.addModifier((ASTNode)this.getPackageDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return this;
    }

    public boolean isProtected() {
        return this.modifiers.hasModifier((ASTNode)this.getPackageDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public JavaPackageInfo setProtected() {
        this.modifiers.clearVisibility((ASTNode)this.getPackageDeclaration());
        this.modifiers.addModifier((ASTNode)this.getPackageDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return this;
    }

    public Visibility getVisibility() {
        return Visibility.getFrom((VisibilityScoped)this);
    }

    public JavaPackageInfo setVisibility(Visibility scope) {
        return (JavaPackageInfo)Visibility.set((VisibilityScoped)this, (Visibility)scope);
    }

    public String toString() {
        Document document = new Document(this.document.get());
        try {
            TextEdit edit = this.unit.rewrite((IDocument)document, null);
            edit.apply((IDocument)document);
        }
        catch (Exception e) {
            throw new ParserException("Could not modify source: " + this.unit.toString(), (Throwable)e);
        }
        return Formatter.format(document.get());
    }

    public Object getInternal() {
        return this.unit;
    }

    public JavaPackageInfo getOrigin() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pkg == null ? 0 : this.pkg.hashCode());
        result = 31 * result + (this.document == null ? 0 : this.document.hashCode());
        result = 31 * result + (this.enclosingType == null ? 0 : this.enclosingType.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaPackageInfoImpl other = (JavaPackageInfoImpl)obj;
        if (this.pkg == null ? other.pkg != null : !this.pkg.equals((Object)other.pkg)) {
            return false;
        }
        if (this.document == null ? other.document != null : !this.document.equals(other.document)) {
            return false;
        }
        if (this.enclosingType == null ? other.enclosingType != null : !this.enclosingType.equals(other.enclosingType)) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals((Object)other.unit));
    }

    public List<SyntaxError> getSyntaxErrors() {
        ArrayList<SyntaxError> result = new ArrayList<SyntaxError>();
        IProblem[] problems = this.unit.getProblems();
        if (problems != null) {
            for (IProblem problem : problems) {
                result.add(new SyntaxErrorImpl((JavaSource<?>)this, problem));
            }
        }
        return result;
    }

    public boolean hasSyntaxErrors() {
        return !this.getSyntaxErrors().isEmpty();
    }

    public boolean isClass() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public List<JavaSource<?>> getNestedClasses() {
        List<AbstractTypeDeclaration> declarations = this.getNestedDeclarations(this.pkg);
        ArrayList result = new ArrayList();
        for (AbstractTypeDeclaration declaration : declarations) {
            result.add(JavaParserImpl.getJavaSource(this, this.document, this.unit, (ASTNode)declaration));
        }
        return result;
    }

    private List<AbstractTypeDeclaration> getNestedDeclarations(ASTNode body) {
        TypeDeclarationFinderVisitor typeDeclarationFinder = new TypeDeclarationFinderVisitor();
        body.accept((ASTVisitor)typeDeclarationFinder);
        List<AbstractTypeDeclaration> declarations = typeDeclarationFinder.getTypeDeclarations();
        ArrayList<AbstractTypeDeclaration> result = new ArrayList<AbstractTypeDeclaration>(declarations);
        if (!declarations.isEmpty()) {
            result.remove(declarations.remove(0));
            for (AbstractTypeDeclaration declaration : declarations) {
                result.removeAll(this.getNestedDeclarations((ASTNode)declaration));
            }
        }
        return result;
    }
}

