/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometdServlet
extends HttpServlet {
    private static final long serialVersionUID = 3637310585741732936L;
    @Deprecated
    public static final int CONFIG_LEVEL = 1;
    @Deprecated
    public static final int INFO_LEVEL = 2;
    @Deprecated
    public static final int DEBUG_LEVEL = 3;
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private volatile BayeuxServerImpl _bayeux;

    public void init() throws ServletException {
        try {
            boolean export = false;
            this._bayeux = (BayeuxServerImpl)this.getServletContext().getAttribute("org.cometd.bayeux");
            if (this._bayeux == null) {
                export = true;
                this._bayeux = this.newBayeuxServer();
                String value = this.getInitParameter("transports");
                if (value != null) {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    if (loader == null) {
                        loader = this.getClass().getClassLoader();
                    }
                    for (String className : value.split(",")) {
                        className = className.trim();
                        try {
                            Class<?> transportClass = loader.loadClass(className);
                            Constructor<?> constructor = transportClass.getConstructor(BayeuxServerImpl.class);
                            ServerTransport transport = (ServerTransport)constructor.newInstance(this._bayeux);
                            this._bayeux.addTransport(transport);
                        }
                        catch (Throwable x) {
                            this._logger.warn("Failed to add transport " + className, x);
                        }
                    }
                }
                if ((value = this.getInitParameter("allowedTransports")) != null) {
                    String[] allowedTransports = value.split(",");
                    for (int i = 0; i < allowedTransports.length; ++i) {
                        allowedTransports[i] = allowedTransports[i].trim();
                    }
                    this._bayeux.setAllowedTransports(allowedTransports);
                }
                Enumeration initParameterNames = this.getInitParameterNames();
                while (initParameterNames.hasMoreElements()) {
                    String initParameterName = (String)initParameterNames.nextElement();
                    value = this.getInitParameter(initParameterName);
                    if ("transports".equals(initParameterName) || "allowedTransports".equalsIgnoreCase(initParameterName)) continue;
                    this._bayeux.setOption(initParameterName, value);
                }
            }
            this._bayeux.start();
            if (export) {
                this.getServletContext().setAttribute("org.cometd.bayeux", this._bayeux);
            }
        }
        catch (Exception x) {
            throw new ServletException(x);
        }
    }

    public BayeuxServerImpl getBayeux() {
        return this._bayeux;
    }

    protected BayeuxServerImpl newBayeuxServer() {
        return new BayeuxServerImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("OPTIONS".equals(request.getMethod())) {
            this.serviceOptions(request, response);
            return;
        }
        HttpTransport transport = null;
        for (String transportName : this._bayeux.getAllowedTransports()) {
            HttpTransport t;
            ServerTransport serverTransport = this._bayeux.getTransport(transportName);
            if (!(serverTransport instanceof HttpTransport) || !(t = (HttpTransport)serverTransport).accept(request)) continue;
            transport = t;
            break;
        }
        if (transport == null) {
            response.sendError(400, "Unknown Bayeux Transport");
        } else {
            try {
                this._bayeux.setCurrentTransport(transport);
                transport.setCurrentRequest(request);
                transport.handle(request, response);
            }
            finally {
                transport.setCurrentRequest(null);
                BayeuxServerImpl bayeux = this._bayeux;
                if (bayeux != null) {
                    bayeux.setCurrentTransport(null);
                }
            }
        }
    }

    protected void serviceOptions(HttpServletRequest request, HttpServletResponse response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        for (ServerSession session : this._bayeux.getSessions()) {
            ((ServerSessionImpl)session).cancelSchedule();
        }
        try {
            this._bayeux.stop();
        }
        catch (Exception x) {
            this._logger.debug("", (Throwable)x);
        }
        finally {
            this._bayeux = null;
            this.getServletContext().removeAttribute("org.cometd.bayeux");
        }
    }
}

